/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class EvaluateZeroLimit
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof LimitNode)) {
            return Optional.empty();
        }
        LimitNode limit = (LimitNode)node;
        if (limit.getCount() != 0L) {
            return Optional.empty();
        }
        return Optional.of(new ValuesNode(limit.getId(), limit.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()));
    }
}

