/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.StatsRecorder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IterativeOptimizer
implements PlanOptimizer {
    private final List<PlanOptimizer> legacyRules;
    private final Set<Rule> rules;
    private final StatsRecorder stats;

    public IterativeOptimizer(StatsRecorder stats, Set<Rule> rules) {
        this(stats, (List<PlanOptimizer>)ImmutableList.of(), rules);
    }

    public IterativeOptimizer(StatsRecorder stats, List<PlanOptimizer> legacyRules, Set<Rule> newRules) {
        this.legacyRules = ImmutableList.copyOf(legacyRules);
        this.rules = ImmutableSet.copyOf(newRules);
        this.stats = stats;
        stats.registerAll(this.rules);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        if (!SystemSessionProperties.isNewOptimizerEnabled(session)) {
            for (PlanOptimizer optimizer : this.legacyRules) {
                plan = optimizer.optimize(plan, session, symbolAllocator.getTypes(), symbolAllocator, idAllocator);
            }
            return plan;
        }
        Memo memo = new Memo(idAllocator, plan);
        Lookup lookup = node -> {
            if (node instanceof GroupReference) {
                return memo.getNode(((GroupReference)node).getGroupId());
            }
            return node;
        };
        this.exploreGroup(memo.getRootGroup(), new Context(memo, lookup, idAllocator, symbolAllocator));
        return memo.extract();
    }

    private boolean exploreGroup(int group, Context context) {
        boolean progress = this.exploreNode(group, context);
        while (this.exploreChildren(group, context)) {
            progress = true;
            if (this.exploreNode(group, context)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context) {
        PlanNode node = context.getMemo().getNode(group);
        boolean done = false;
        boolean progress = false;
        while (!done) {
            done = true;
            for (Rule rule : this.rules) {
                long duration;
                Optional<PlanNode> transformed;
                try {
                    long start = System.nanoTime();
                    transformed = rule.apply(node, context.getLookup(), context.getIdAllocator(), context.getSymbolAllocator());
                    duration = System.nanoTime() - start;
                }
                catch (RuntimeException e) {
                    this.stats.recordFailure(rule);
                    throw e;
                }
                this.stats.record(rule, duration, transformed.isPresent());
                if (!transformed.isPresent()) continue;
                node = context.getMemo().replace(group, transformed.get(), rule.getClass().getName());
                done = false;
                progress = true;
            }
        }
        return progress;
    }

    private boolean exploreChildren(int group, Context context) {
        boolean progress = false;
        PlanNode expression = context.getMemo().getNode(group);
        for (PlanNode child : expression.getSources()) {
            Preconditions.checkState((boolean)(child instanceof GroupReference), (Object)("Expected child to be a group reference. Found: " + child.getClass().getName()));
            if (!this.exploreGroup(((GroupReference)child).getGroupId(), context)) continue;
            progress = true;
        }
        return progress;
    }

    private static class Context {
        private final Memo memo;
        private final Lookup lookup;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;

        public Context(Memo memo, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.memo = memo;
            this.lookup = lookup;
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
        }

        public Memo getMemo() {
            return this.memo;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public PlanNodeIdAllocator getIdAllocator() {
            return this.idAllocator;
        }

        public SymbolAllocator getSymbolAllocator() {
            return this.symbolAllocator;
        }
    }
}

