/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class SymbolExtractor {
    private SymbolExtractor() {
    }

    public static Set<Symbol> extract(PlanNode node) {
        Visitor visitor = new Visitor();
        node.accept(visitor, null);
        return visitor.getSymbols();
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final ImmutableSet.Builder<Symbol> symbols = ImmutableSet.builder();

        private Visitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            this.symbols.addAll(node.getOutputSymbols());
            return super.visitPlan(node, context);
        }

        public Set<Symbol> getSymbols() {
            return this.symbols.build();
        }
    }
}

