/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SymbolAllocator {
    private final Map<Symbol, Type> symbols;
    private int nextId;

    public SymbolAllocator() {
        this.symbols = new HashMap<Symbol, Type>();
    }

    public SymbolAllocator(Map<Symbol, Type> initial) {
        this.symbols = new HashMap<Symbol, Type>(initial);
    }

    public Symbol newSymbol(String nameHint, Type type) {
        return this.newSymbol(nameHint, type, null);
    }

    public Symbol newHashSymbol() {
        return this.newSymbol("$hashValue", (Type)BigintType.BIGINT);
    }

    public Symbol newSymbol(String nameHint, Type type, String suffix) {
        String tail;
        Objects.requireNonNull(nameHint, "name is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (Ints.tryParse((String)(tail = nameHint.substring(index + 1))) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        String unique = nameHint;
        if (suffix != null) {
            unique = unique + "$" + suffix;
        }
        String attempt = unique;
        while (this.symbols.containsKey(new Symbol(attempt))) {
            attempt = unique + "_" + this.nextId();
        }
        Symbol symbol = new Symbol(attempt);
        this.symbols.put(symbol, type);
        return symbol;
    }

    public Symbol newSymbol(Expression expression, Type type) {
        return this.newSymbol(expression, type, null);
    }

    public Symbol newSymbol(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof Identifier) {
            nameHint = ((Identifier)expression).getName();
        } else if (expression instanceof FunctionCall) {
            nameHint = ((FunctionCall)expression).getName().getSuffix();
        } else if (expression instanceof SymbolReference) {
            nameHint = ((SymbolReference)expression).getName();
        }
        return this.newSymbol(nameHint, type, suffix);
    }

    public Symbol newSymbol(Field field) {
        String nameHint = field.getName().orElse("field");
        return this.newSymbol(nameHint, field.getType());
    }

    public Map<Symbol, Type> getTypes() {
        return this.symbols;
    }

    private int nextId() {
        return this.nextId++;
    }
}

