/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperatorFactory;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SimpleJoinProbe;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JoinProbeCompiler {
    private final LoadingCache<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory> joinProbeFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory>(){

        public HashJoinOperatorFactoryFactory load(JoinOperatorCacheKey key) throws Exception {
            return JoinProbeCompiler.this.internalCompileJoinOperatorFactory(key.getTypes(), key.getProbeOutputChannels(), key.getProbeChannels(), key.getProbeHashChannel());
        }
    });

    public OperatorFactory compileJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, LookupSourceFactory lookupSourceFactory, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, Optional<Integer> probeHashChannel, List<Integer> probeOutputChannels, LookupJoinOperators.JoinType joinType) {
        try {
            List probeOutputChannelTypes = (List)probeOutputChannels.stream().map(probeTypes::get).collect(ImmutableCollectors.toImmutableList());
            HashJoinOperatorFactoryFactory operatorFactoryFactory = (HashJoinOperatorFactoryFactory)this.joinProbeFactories.get((Object)new JoinOperatorCacheKey(probeTypes, probeOutputChannels, probeJoinChannel, probeHashChannel, joinType));
            return operatorFactoryFactory.createHashJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeOutputChannelTypes, joinType);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @VisibleForTesting
    public HashJoinOperatorFactoryFactory internalCompileJoinOperatorFactory(List<Type> types, List<Integer> probeOutputChannels, List<Integer> probeJoinChannel, Optional<Integer> probeHashChannel) {
        JoinProbeFactory joinProbeFactory;
        Class<? extends JoinProbe> joinProbeClass = this.compileJoinProbe(types, probeOutputChannels, probeJoinChannel, probeHashChannel);
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"JoinProbeFactory"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(JoinProbeFactory.class)});
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        Parameter lookupSource = Parameter.arg((String)"lookupSource", LookupSource.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "createJoinProbe", ParameterizedType.type(JoinProbe.class), new Parameter[]{lookupSource, page});
        method.getBody().newObject(joinProbeClass).dup().append((BytecodeNode)lookupSource).append((BytecodeNode)page).invokeConstructor(joinProbeClass, new Class[]{LookupSource.class, Page.class}).retObject();
        DynamicClassLoader classLoader = new DynamicClassLoader(joinProbeClass.getClassLoader());
        if (probeJoinChannel.isEmpty()) {
            joinProbeFactory = new SimpleJoinProbe.SimpleJoinProbeFactory(types, probeOutputChannels, probeJoinChannel, probeHashChannel);
        } else {
            Class joinProbeFactoryClass = CompilerUtils.defineClass((ClassDefinition)classDefinition, JoinProbeFactory.class, (DynamicClassLoader)classLoader);
            try {
                joinProbeFactory = (JoinProbeFactory)joinProbeFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        Class<LookupJoinOperatorFactory> operatorFactoryClass = IsolatedClass.isolateClass(classLoader, OperatorFactory.class, LookupJoinOperatorFactory.class, LookupJoinOperator.class);
        return new HashJoinOperatorFactoryFactory(joinProbeFactory, operatorFactoryClass);
    }

    @VisibleForTesting
    public JoinProbeFactory internalCompileJoinProbe(List<Type> types, List<Integer> probeOutputChannels, List<Integer> probeChannels, Optional<Integer> probeHashChannel) {
        return new ReflectionJoinProbeFactory(this.compileJoinProbe(types, probeOutputChannels, probeChannels, probeHashChannel));
    }

    private Class<? extends JoinProbe> compileJoinProbe(List<Type> types, List<Integer> probeOutputChannels, List<Integer> probeChannels, Optional<Integer> probeHashChannel) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"JoinProbe"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(JoinProbe.class)});
        FieldDefinition lookupSourceField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "lookupSource", LookupSource.class);
        FieldDefinition positionCountField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "positionCount", Integer.TYPE);
        ArrayList<FieldDefinition> blockFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "block_" + i, Block.class);
            blockFields.add(channelField);
        }
        ArrayList<FieldDefinition> probeBlockFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < probeChannels.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "probeBlock_" + i, Block.class);
            probeBlockFields.add(channelField);
        }
        FieldDefinition probeBlocksArrayField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "probeBlocks", Block[].class);
        FieldDefinition probePageField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "probePage", Page.class);
        FieldDefinition pageField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "page", Page.class);
        FieldDefinition positionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "position", Integer.TYPE);
        FieldDefinition probeHashBlockField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "probeHashBlock", Block.class);
        JoinProbeCompiler.generateConstructor(classDefinition, probeChannels, probeHashChannel, lookupSourceField, blockFields, probeBlockFields, probeBlocksArrayField, probePageField, pageField, probeHashBlockField, positionField, positionCountField);
        JoinProbeCompiler.generateGetChannelCountMethod(classDefinition, probeOutputChannels.size());
        JoinProbeCompiler.generateAppendToMethod(classDefinition, callSiteBinder, types, probeOutputChannels, blockFields, positionField);
        JoinProbeCompiler.generateAdvanceNextPosition(classDefinition, positionField, positionCountField);
        JoinProbeCompiler.generateGetCurrentJoinPosition(classDefinition, callSiteBinder, lookupSourceField, probePageField, pageField, probeHashChannel, probeHashBlockField, positionField);
        JoinProbeCompiler.generateCurrentRowContainsNull(classDefinition, probeBlockFields, positionField);
        JoinProbeCompiler.generateGetPosition(classDefinition, positionField);
        JoinProbeCompiler.generateGetPage(classDefinition, pageField);
        return CompilerUtils.defineClass((ClassDefinition)classDefinition, JoinProbe.class, callSiteBinder.getBindings(), (ClassLoader)this.getClass().getClassLoader());
    }

    private static void generateConstructor(ClassDefinition classDefinition, List<Integer> probeChannels, Optional<Integer> probeHashChannel, FieldDefinition lookupSourceField, List<FieldDefinition> blockFields, List<FieldDefinition> probeChannelFields, FieldDefinition probeBlocksArrayField, FieldDefinition probePageField, FieldDefinition pageField, FieldDefinition probeHashBlockField, FieldDefinition positionField, FieldDefinition positionCountField) {
        int index;
        Parameter lookupSource = Parameter.arg((String)"lookupSource", LookupSource.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{lookupSource, page});
        Variable thisVariable = constructorDefinition.getThis();
        BytecodeBlock constructor = constructorDefinition.getBody().comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.lookupSource = lookupSource;").append((BytecodeNode)thisVariable.setField(lookupSourceField, (BytecodeExpression)lookupSource));
        constructor.comment("this.positionCount = page.getPositionCount();").append((BytecodeNode)thisVariable.setField(positionCountField, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        constructor.comment("Set block fields");
        for (index = 0; index < blockFields.size(); ++index) {
            constructor.append((BytecodeNode)thisVariable.setField(blockFields.get(index), page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)})));
        }
        constructor.comment("Set probe channel fields");
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.append((BytecodeNode)thisVariable.setField(probeChannelFields.get(index), thisVariable.getField(blockFields.get(probeChannels.get(index)))));
        }
        constructor.comment("this.probeBlocks = new Block[<probeChannelCount>];");
        constructor.append((BytecodeNode)thisVariable).push(probeChannelFields.size()).newArray(Block.class).putField(probeBlocksArrayField);
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.append((BytecodeNode)thisVariable).getField(probeBlocksArrayField).push(index).append((BytecodeNode)thisVariable).getField(probeChannelFields.get(index)).putObjectArrayElement();
        }
        constructor.comment("this.page = page").append((BytecodeNode)thisVariable.setField(pageField, (BytecodeExpression)page));
        constructor.comment("this.probePage = new Page(probeBlocks)").append((BytecodeNode)thisVariable.setField(probePageField, BytecodeExpressions.newInstance(Page.class, (BytecodeExpression[])new BytecodeExpression[]{thisVariable.getField(probeBlocksArrayField)})));
        if (probeHashChannel.isPresent()) {
            Integer index2 = probeHashChannel.get();
            constructor.comment("this.probeHashBlock = blocks[hashChannel.get()]").append((BytecodeNode)thisVariable.setField(probeHashBlockField, thisVariable.getField(blockFields.get(index2))));
        }
        constructor.comment("this.position = -1;").append((BytecodeNode)thisVariable.setField(positionField, BytecodeExpressions.constantInt((int)-1)));
        constructor.ret();
    }

    private static void generateGetChannelCountMethod(ClassDefinition classDefinition, int channelCount) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getOutputChannelCount", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().push(channelCount).retInt();
    }

    private static void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<Integer> probeOutputChannels, List<FieldDefinition> blockFields, FieldDefinition positionField) {
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "appendTo", ParameterizedType.type(Void.TYPE), new Parameter[]{pageBuilder});
        Variable thisVariable = method.getThis();
        int pageBuilderOutputChannel = 0;
        for (int outputChannel : probeOutputChannels) {
            Type type = types.get(outputChannel);
            method.getBody().comment("%s.appendTo(block_%s, position, pageBuilder.getBlockBuilder(%s));", new Object[]{type.getClass(), outputChannel, pageBuilderOutputChannel}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type).invoke("appendTo", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(blockFields.get(outputChannel)), thisVariable.getField(positionField), pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)pageBuilderOutputChannel++)})}));
        }
        method.getBody().ret();
    }

    private static void generateAdvanceNextPosition(ClassDefinition classDefinition, FieldDefinition positionField, FieldDefinition positionCountField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "advanceNextPosition", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        method.getBody().comment("this.position = this.position + 1;").append((BytecodeNode)thisVariable).append((BytecodeNode)thisVariable).getField(positionField).push(1).intAdd().putField(positionField);
        LabelNode lessThan = new LabelNode("lessThan");
        LabelNode end = new LabelNode("end");
        method.getBody().comment("return position < positionCount;").append((BytecodeNode)thisVariable).getField(positionField).append((BytecodeNode)thisVariable).getField(positionCountField).append((BytecodeNode)JumpInstruction.jumpIfIntLessThan((LabelNode)lessThan)).push(false).gotoLabel(end).visitLabel(lessThan).push(true).visitLabel(end).retBoolean();
    }

    private static void generateGetCurrentJoinPosition(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, FieldDefinition lookupSourceField, FieldDefinition probePageField, FieldDefinition pageField, Optional<Integer> probeHashChannel, FieldDefinition probeHashBlockField, FieldDefinition positionField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getCurrentJoinPosition", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)thisVariable.invoke("currentRowContainsNull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)BytecodeExpressions.constantLong((long)-1L).ret()));
        BytecodeExpression position = thisVariable.getField(positionField);
        BytecodeExpression hashChannelsPage = thisVariable.getField(probePageField);
        BytecodeExpression allChannelsPage = thisVariable.getField(pageField);
        BytecodeExpression probeHashBlock = thisVariable.getField(probeHashBlockField);
        if (probeHashChannel.isPresent()) {
            body.append((BytecodeNode)thisVariable.getField(lookupSourceField).invoke("getJoinPosition", Long.TYPE, new BytecodeExpression[]{position, hashChannelsPage, allChannelsPage, SqlTypeBytecodeExpression.constantType(callSiteBinder, (Type)BigintType.BIGINT).invoke("getLong", Long.TYPE, new BytecodeExpression[]{probeHashBlock, position})})).retLong();
        } else {
            body.append((BytecodeNode)thisVariable.getField(lookupSourceField).invoke("getJoinPosition", Long.TYPE, new BytecodeExpression[]{position, hashChannelsPage, allChannelsPage})).retLong();
        }
    }

    private static void generateCurrentRowContainsNull(ClassDefinition classDefinition, List<FieldDefinition> probeBlockFields, FieldDefinition positionField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), "currentRowContainsNull", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        for (FieldDefinition probeBlockField : probeBlockFields) {
            LabelNode checkNextField = new LabelNode("checkNextField");
            method.getBody().append((BytecodeNode)thisVariable.getField(probeBlockField).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{thisVariable.getField(positionField)})).ifFalseGoto(checkNextField).push(true).retBoolean().visitLabel(checkNextField);
        }
        method.getBody().push(false).retInt();
    }

    private static void generateGetPosition(ClassDefinition classDefinition, FieldDefinition positionField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getPosition", ParameterizedType.type(Integer.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        method.getBody().append((BytecodeNode)thisVariable.getField(positionField)).retInt();
    }

    private static void generateGetPage(ClassDefinition classDefinition, FieldDefinition pageField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getPage", ParameterizedType.type(Page.class), new Parameter[0]);
        Variable thisVariable = method.getThis();
        method.getBody().append((BytecodeNode)thisVariable.getField(pageField)).ret(Page.class);
    }

    public static void checkState(boolean left, boolean right) {
        if (left != right) {
            throw new IllegalStateException();
        }
    }

    private static class HashJoinOperatorFactoryFactory {
        private final JoinProbeFactory joinProbeFactory;
        private final Constructor<? extends OperatorFactory> constructor;

        private HashJoinOperatorFactoryFactory(JoinProbeFactory joinProbeFactory, Class<? extends OperatorFactory> operatorFactoryClass) {
            this.joinProbeFactory = joinProbeFactory;
            try {
                this.constructor = operatorFactoryClass.getConstructor(Integer.TYPE, PlanNodeId.class, LookupSourceFactory.class, List.class, List.class, LookupJoinOperators.JoinType.class, JoinProbeFactory.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public OperatorFactory createHashJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, LookupSourceFactory lookupSourceFactory, List<? extends Type> probeTypes, List<? extends Type> probeOutputTypes, LookupJoinOperators.JoinType joinType) {
            try {
                return this.constructor.newInstance(new Object[]{operatorId, planNodeId, lookupSourceFactory, probeTypes, probeOutputTypes, joinType, this.joinProbeFactory});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class JoinOperatorCacheKey {
        private final List<Type> types;
        private final List<Integer> probeOutputChannels;
        private final List<Integer> probeChannels;
        private final LookupJoinOperators.JoinType joinType;
        private final Optional<Integer> probeHashChannel;

        private JoinOperatorCacheKey(List<? extends Type> types, List<Integer> probeOutputChannels, List<Integer> probeChannels, Optional<Integer> probeHashChannel, LookupJoinOperators.JoinType joinType) {
            this.probeHashChannel = probeHashChannel;
            this.types = ImmutableList.copyOf(types);
            this.probeOutputChannels = ImmutableList.copyOf(probeOutputChannels);
            this.probeChannels = ImmutableList.copyOf(probeChannels);
            this.joinType = joinType;
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getProbeOutputChannels() {
            return this.probeOutputChannels;
        }

        private List<Integer> getProbeChannels() {
            return this.probeChannels;
        }

        private Optional<Integer> getProbeHashChannel() {
            return this.probeHashChannel;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.types, this.probeOutputChannels, this.probeChannels, this.joinType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JoinOperatorCacheKey)) {
                return false;
            }
            JoinOperatorCacheKey other = (JoinOperatorCacheKey)obj;
            return Objects.equals(this.types, other.types) && Objects.equals(this.probeOutputChannels, other.probeOutputChannels) && Objects.equals(this.probeChannels, other.probeChannels) && Objects.equals(this.probeHashChannel, other.probeHashChannel) && Objects.equals((Object)this.joinType, (Object)other.joinType);
        }
    }

    public static class ReflectionJoinProbeFactory
    implements JoinProbeFactory {
        private final Constructor<? extends JoinProbe> constructor;

        public ReflectionJoinProbeFactory(Class<? extends JoinProbe> joinProbeClass) {
            try {
                this.constructor = joinProbeClass.getConstructor(LookupSource.class, Page.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            try {
                return this.constructor.newInstance(lookupSource, page);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

