/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class CoalesceCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        ArrayList<BytecodeNode> operands = new ArrayList<BytecodeNode>();
        for (RowExpression expression : arguments) {
            operands.add(generatorContext.generate(expression));
        }
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock nullValue = new BytecodeBlock().append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        for (BytecodeNode operand : Lists.reverse(operands)) {
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition().append(operand).append((BytecodeNode)wasNull);
            ifStatement.ifTrue().pop(returnType.getJavaType()).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).append((BytecodeNode)nullValue);
            nullValue = ifStatement;
        }
        return nullValue;
    }
}

