/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.security.ViewAccessControl;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.AggregationAnalyzer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.analyzer.WindowFunctionValidator;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class StatementAnalyzer
extends DefaultTraversalVisitor<Scope, Scope> {
    private final Analysis analysis;
    private final Metadata metadata;
    private final Session session;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;

    public StatementAnalyzer(Analysis analysis, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Session session) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    protected Scope visitUse(Use node, Scope scope) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
    }

    protected Scope visitInsert(Insert insert, Scope scope) {
        List insertColumns;
        QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(this.session, (Node)insert, insert.getTarget());
        if (this.metadata.getView(this.session, targetTable).isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into views is not supported", new Object[0]);
        }
        Scope queryScope = (Scope)this.process((Node)insert.getQuery(), scope);
        this.analysis.setUpdateType("INSERT");
        Optional<TableHandle> targetTableHandle = this.metadata.getTableHandle(this.session, targetTable);
        if (!targetTableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)insert, "Table '%s' does not exist", targetTable);
        }
        this.accessControl.checkCanInsertIntoTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), targetTable);
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTableHandle.get());
        List tableColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableCollectors.toImmutableList());
        if (insert.getColumns().isPresent()) {
            insertColumns = (List)((List)insert.getColumns().get()).stream().map(String::toLowerCase).collect(ImmutableCollectors.toImmutableList());
            HashSet<String> columnNames = new HashSet<String>();
            for (String insertColumn2 : insertColumns) {
                if (!tableColumns.contains(insertColumn2)) {
                    throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)insert, "Insert column name does not exist in target table: %s", insertColumn2);
                }
                if (columnNames.add(insertColumn2)) continue;
                throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)insert, "Insert column name is specified more than once: %s", insertColumn2);
            }
        } else {
            insertColumns = tableColumns;
        }
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTableHandle.get());
        this.analysis.setInsert(new Analysis.Insert(targetTableHandle.get(), (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableCollectors.toImmutableList())));
        Iterable tableTypes = (Iterable)insertColumns.stream().map(insertColumn -> tableMetadata.getColumn((String)insertColumn).getType()).collect(ImmutableCollectors.toImmutableList());
        Iterable queryTypes = Iterables.transform(queryScope.getRelationType().getVisibleFields(), Field::getType);
        if (!this.typesMatchForInsert(tableTypes, queryTypes)) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)insert, "Insert query has mismatched column types: Table: [" + Joiner.on((String)", ").join(tableTypes) + "], Query: [" + Joiner.on((String)", ").join(queryTypes) + "]", new Object[0]);
        }
        return this.createScope((Node)insert, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    private boolean typesMatchForInsert(Iterable<Type> tableTypes, Iterable<Type> queryTypes) {
        if (Iterables.size(tableTypes) != Iterables.size(queryTypes)) {
            return false;
        }
        Iterator<Type> tableTypesIterator = tableTypes.iterator();
        Iterator<Type> queryTypesIterator = queryTypes.iterator();
        while (tableTypesIterator.hasNext()) {
            Type tableType = tableTypesIterator.next();
            Type queryType = queryTypesIterator.next();
            if (this.metadata.getTypeManager().canCoerce(queryType, tableType)) continue;
            return false;
        }
        return true;
    }

    protected Scope visitDelete(Delete node, Scope scope) {
        Table table = node.getTable();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName());
        if (this.metadata.getView(this.session, tableName).isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from views is not supported", new Object[0]);
        }
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, new AllowAllAccessControl(), this.session);
        Scope tableScope = (Scope)analyzer.process((Node)table, scope);
        node.getWhere().ifPresent(where -> analyzer.analyzeWhere((Node)node, tableScope, (Expression)where));
        this.analysis.setUpdateType("DELETE");
        this.accessControl.checkCanDeleteFromTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), tableName);
        return this.createScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    protected Scope visitCreateTableAsSelect(CreateTableAsSelect node, Scope scope) {
        this.analysis.setUpdateType("CREATE TABLE");
        QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
        this.analysis.setCreateTableDestination(targetTable);
        Optional<TableHandle> targetTableHandle = this.metadata.getTableHandle(this.session, targetTable);
        if (targetTableHandle.isPresent()) {
            if (node.isNotExists()) {
                this.analysis.setCreateTableAsSelectNoOp(true);
                return this.createScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
            }
            throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", targetTable);
        }
        for (Expression expression : node.getProperties().values()) {
            ExpressionAnalyzer.createConstantAnalyzer(this.metadata, this.session, this.analysis.getParameters(), this.analysis.isDescribe()).analyze(expression, scope);
        }
        this.analysis.setCreateTableProperties(node.getProperties());
        this.accessControl.checkCanCreateTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), targetTable);
        this.analysis.setCreateTableAsSelectWithData(node.isWithData());
        Scope queryScope = (Scope)this.process((Node)node.getQuery(), scope);
        StatementAnalyzer.validateColumns((Statement)node, queryScope.getRelationType());
        return this.createScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    protected Scope visitCreateView(CreateView node, Scope scope) {
        this.analysis.setUpdateType("CREATE VIEW");
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, new ViewAccessControl(this.accessControl), this.session);
        Scope queryScope = (Scope)analyzer.process((Node)node.getQuery(), scope);
        this.accessControl.checkCanCreateView(this.session.getRequiredTransactionId(), this.session.getIdentity(), viewName);
        StatementAnalyzer.validateColumns((Statement)node, queryScope.getRelationType());
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitSetSession(SetSession node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitResetSession(ResetSession node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitAddColumn(AddColumn node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitCreateSchema(CreateSchema node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitDropSchema(DropSchema node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitRenameSchema(RenameSchema node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitCreateTable(CreateTable node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitDropTable(DropTable node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitRenameTable(RenameTable node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitRenameColumn(RenameColumn node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitDropView(DropView node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitStartTransaction(StartTransaction node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitCommit(Commit node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitRollback(Rollback node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitPrepare(Prepare node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitDeallocate(Deallocate node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitExecute(Execute node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitGrant(Grant node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitRevoke(Revoke node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    protected Scope visitCall(Call node, Scope scope) {
        return this.createScope((Node)node, scope, Collections.emptyList());
    }

    private static void validateColumns(Statement node, RelationType descriptor) {
        HashSet<String> names = new HashSet<String>();
        for (Field field : descriptor.getVisibleFields()) {
            Optional<String> fieldName = field.getName();
            if (!fieldName.isPresent()) {
                throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)node, "Column name not specified at position %s", descriptor.indexOf(field) + 1);
            }
            if (!names.add(fieldName.get())) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", fieldName.get());
            }
            if (!field.getType().equals((Object)UnknownType.UNKNOWN)) continue;
            throw new SemanticException(SemanticErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown: %s", fieldName.get());
        }
    }

    protected Scope visitExplain(Explain node, Scope scope) throws SemanticException {
        Preconditions.checkState((boolean)node.isAnalyze(), (Object)"Non analyze explain should be rewritten to Query");
        if (node.getOptions().stream().anyMatch(option -> !option.equals((Object)new ExplainType(ExplainType.Type.DISTRIBUTED)))) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXPLAIN ANALYZE only supports TYPE DISTRIBUTED option", new Object[0]);
        }
        this.process((Node)node.getStatement(), scope);
        this.analysis.setUpdateType(null);
        return this.createScope((Node)node, scope, Field.newUnqualified("Query Plan", (Type)VarcharType.VARCHAR));
    }

    protected Scope visitQuery(Query node, Scope scope) {
        Scope withScope = this.analyzeWith(node, scope);
        Scope queryScope = Scope.builder().withParent(withScope).build();
        Scope queryBodyScope = (Scope)this.process((Node)node.getQueryBody(), queryScope);
        this.analyzeOrderBy(node, queryBodyScope);
        this.analysis.setOutputExpressions((Node)node, this.descriptorToFields(queryBodyScope));
        queryScope = Scope.builder().withParent(withScope).withRelationType(queryBodyScope.getRelationType()).build();
        this.analysis.setScope((Node)node, queryScope);
        return queryScope;
    }

    protected Scope visitUnnest(Unnest node, Scope scope) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (Expression expression : node.getExpressions()) {
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, scope);
            Type expressionType = expressionAnalysis.getType(expression);
            if (expressionType instanceof ArrayType) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((ArrayType)expressionType).getElementType()));
                continue;
            }
            if (expressionType instanceof MapType) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getKeyType()));
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getValueType()));
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + expressionType);
        }
        if (node.isWithOrdinality()) {
            outputFields.add((Object)Field.newUnqualified(Optional.empty(), (Type)BigintType.BIGINT));
        }
        return this.createScope((Node)node, scope, (List<Field>)outputFields.build());
    }

    protected Scope visitTable(Table table, Scope scope) {
        Object name;
        Optional<WithQuery> withQuery;
        if (!table.getName().getPrefix().isPresent() && (withQuery = scope.getNamedQuery((String)(name = table.getName().getSuffix()))).isPresent()) {
            List fields;
            Query query = withQuery.get().getQuery();
            this.analysis.registerNamedQuery(table, query);
            RelationType queryDescriptor = this.analysis.getOutputDescriptor((Node)query);
            Optional columnNames = withQuery.get().getColumnNames();
            if (columnNames.isPresent()) {
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                int field = 0;
                for (String columnName : (List)columnNames.get()) {
                    Field inputField = queryDescriptor.getFieldByIndex(field);
                    fieldBuilder.add((Object)Field.newQualified(QualifiedName.of((String)name), Optional.of(columnName), inputField.getType(), false, inputField.getOriginTable(), inputField.isAliased()));
                    ++field;
                }
                fields = fieldBuilder.build();
            } else {
                fields = (List)queryDescriptor.getAllFields().stream().map(arg_0 -> StatementAnalyzer.lambda$visitTable$4((String)name, arg_0)).collect(ImmutableCollectors.toImmutableList());
            }
            return this.createScope((Node)table, scope, fields);
        }
        name = MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName());
        Optional<ViewDefinition> optionalView = this.metadata.getView(this.session, (QualifiedObjectName)name);
        if (optionalView.isPresent()) {
            Statement statement = this.analysis.getStatement();
            if (statement instanceof CreateView) {
                CreateView viewStatement = (CreateView)statement;
                QualifiedObjectName viewNameFromStatement = MetadataUtil.createQualifiedObjectName(this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals(name)) {
                    throw new SemanticException(SemanticErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive view", new Object[0]);
                }
            }
            if (this.analysis.hasTableInView(table)) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_RECURSIVE, (Node)table, "View is recursive", new Object[0]);
            }
            ViewDefinition view = optionalView.get();
            Query query = this.parseView(view.getOriginalSql(), (QualifiedObjectName)name, (Node)table);
            this.analysis.registerNamedQuery(table, query);
            this.accessControl.checkCanSelectFromView(this.session.getRequiredTransactionId(), this.session.getIdentity(), (QualifiedObjectName)name);
            this.analysis.registerTableForView(table);
            RelationType descriptor = this.analyzeView(query, (QualifiedObjectName)name, view.getCatalog(), view.getSchema(), view.getOwner(), table);
            this.analysis.unregisterTableForView();
            if (this.isViewStale(view.getColumns(), descriptor.getVisibleFields())) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale; it must be re-created", name);
            }
            List outputFields = (List)view.getColumns().stream().map(arg_0 -> StatementAnalyzer.lambda$visitTable$5((QualifiedObjectName)name, arg_0)).collect(ImmutableCollectors.toImmutableList());
            this.analysis.addRelationCoercion((Relation)table, (Type[])outputFields.stream().map(Field::getType).toArray(Type[]::new));
            return this.createScope((Node)table, scope, outputFields);
        }
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, (QualifiedObjectName)name);
        if (!tableHandle.isPresent()) {
            if (!this.metadata.getCatalogHandle(this.session, ((QualifiedObjectName)name).getCatalogName()).isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)table, "Catalog %s does not exist", ((QualifiedObjectName)name).getCatalogName());
            }
            if (!this.metadata.schemaExists(this.session, new CatalogSchemaName(((QualifiedObjectName)name).getCatalogName(), ((QualifiedObjectName)name).getSchemaName()))) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema %s does not exist", ((QualifiedObjectName)name).getSchemaName());
            }
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table %s does not exist", name);
        }
        this.accessControl.checkCanSelectFromTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), (QualifiedObjectName)name);
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle.get());
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle.get());
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Field field = Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), column.isHidden(), Optional.of(name), false);
            fields.add((Object)field);
            ColumnHandle columnHandle = columnHandles.get(column.getName());
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object[])new Object[]{field});
            this.analysis.setColumn(field, columnHandle);
        }
        this.analysis.registerTable(table, tableHandle.get());
        return this.createScope((Node)table, scope, (List<Field>)fields.build());
    }

    protected Scope visitAliasedRelation(AliasedRelation relation, Scope scope) {
        int totalColumns;
        Scope relationScope = (Scope)this.process((Node)relation.getRelation(), scope);
        RelationType relationType = relationScope.getRelationType();
        if (relation.getColumnNames() != null && (totalColumns = relationType.getVisibleFieldCount()) != relation.getColumnNames().size()) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
        }
        RelationType descriptor = relationType.withAlias(relation.getAlias(), relation.getColumnNames());
        return this.createScope((Node)relation, scope, descriptor);
    }

    protected Scope visitSampledRelation(SampledRelation relation, Scope scope) {
        if (!DependencyExtractor.extractNames(relation.getSamplePercentage(), this.analysis.getColumnReferences()).isEmpty()) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
        }
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), relation.getSamplePercentage(), this.analysis.getParameters(), this.analysis.isDescribe());
        ExpressionInterpreter samplePercentageEval = ExpressionInterpreter.expressionOptimizer(relation.getSamplePercentage(), this.metadata, this.session, expressionTypes);
        Object samplePercentageObject = samplePercentageEval.optimize(symbol -> {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
        });
        if (!(samplePercentageObject instanceof Number)) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage should evaluate to a numeric expression", new Object[0]);
        }
        double samplePercentageValue = ((Number)samplePercentageObject).doubleValue();
        if (samplePercentageValue < 0.0) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be greater than or equal to 0", new Object[0]);
        }
        if (samplePercentageValue > 100.0) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be less than or equal to 100", new Object[0]);
        }
        this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
        Scope relationScope = (Scope)this.process((Node)relation.getRelation(), scope);
        return this.createScope((Node)relation, scope, relationScope.getRelationType());
    }

    protected Scope visitTableSubquery(TableSubquery node, Scope scope) {
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, this.accessControl, this.session);
        Scope queryScope = (Scope)analyzer.process((Node)node.getQuery(), scope);
        return this.createScope((Node)node, scope, queryScope.getRelationType());
    }

    protected Scope visitQuerySpecification(QuerySpecification node, Scope scope) {
        Scope sourceScope = this.analyzeFrom(node, scope);
        node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, sourceScope, (Expression)where));
        List<Expression> outputExpressions = this.analyzeSelect(node, sourceScope);
        List<List<Expression>> groupByExpressions = this.analyzeGroupBy(node, sourceScope, outputExpressions);
        Scope outputScope = this.computeOutputScope(node, sourceScope);
        List<Expression> orderByExpressions = this.analyzeOrderBy(node, sourceScope, outputScope, outputExpressions);
        this.analyzeHaving(node, sourceScope);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.addAll(outputExpressions);
        expressions.addAll(orderByExpressions);
        node.getHaving().ifPresent(expressions::add);
        this.analyzeAggregations(node, sourceScope, groupByExpressions, this.analysis.getColumnReferences(), expressions);
        this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
        return outputScope;
    }

    protected Scope visitSetOperation(SetOperation node, Scope scope) {
        int i;
        Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
        List relationScopes = (List)node.getRelations().stream().map(relation -> {
            Scope relationScope = (Scope)this.process((Node)relation, scope);
            return this.createScope((Node)relation, scope, relationScope.getRelationType().withOnlyVisibleFields());
        }).collect(ImmutableCollectors.toImmutableList());
        Type[] outputFieldTypes = (Type[])((Scope)relationScopes.get(0)).getRelationType().getVisibleFields().stream().map(Field::getType).toArray(Type[]::new);
        for (Scope relationScope : relationScopes) {
            int outputFieldSize = outputFieldTypes.length;
            RelationType relationType = relationScope.getRelationType();
            int descFieldSize = relationType.getVisibleFields().size();
            String setOperationName = node.getClass().getSimpleName();
            if (outputFieldSize != descFieldSize) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "%s query has different number of fields: %d, %d", setOperationName, outputFieldSize, descFieldSize);
            }
            for (int i2 = 0; i2 < descFieldSize; ++i2) {
                Type descFieldType = relationType.getFieldByIndex(i2).getType();
                Optional commonSuperType = this.metadata.getTypeManager().getCommonSuperType(outputFieldTypes[i2], descFieldType);
                if (!commonSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "column %d in %s query has incompatible types: %s, %s", i2, outputFieldTypes[i2].getDisplayName(), setOperationName, descFieldType.getDisplayName());
                }
                outputFieldTypes[i2] = (Type)commonSuperType.get();
            }
        }
        Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
        RelationType firstDescriptor = ((Scope)relationScopes.get(0)).getRelationType().withOnlyVisibleFields();
        for (i = 0; i < outputFieldTypes.length; ++i) {
            Field oldField = firstDescriptor.getFieldByIndex(i);
            outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.isAliased());
        }
        block3: for (i = 0; i < node.getRelations().size(); ++i) {
            Relation relation2 = (Relation)node.getRelations().get(i);
            Scope relationScope = (Scope)relationScopes.get(i);
            RelationType relationType = relationScope.getRelationType();
            for (int j = 0; j < relationType.getVisibleFields().size(); ++j) {
                Type outputFieldType = outputFieldTypes[j];
                Type descFieldType = relationType.getFieldByIndex(j).getType();
                if (outputFieldType.equals(descFieldType)) continue;
                this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                continue block3;
            }
        }
        return this.createScope((Node)node, scope, outputDescriptorFields);
    }

    protected Scope visitIntersect(Intersect node, Scope scope) {
        if (!node.isDistinct()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "INTERSECT ALL not yet implemented", new Object[0]);
        }
        return this.visitSetOperation((SetOperation)node, scope);
    }

    protected Scope visitExcept(Except node, Scope scope) {
        if (!node.isDistinct()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXCEPT ALL not yet implemented", new Object[0]);
        }
        return this.visitSetOperation((SetOperation)node, scope);
    }

    /*
     * Unable to fully structure code
     */
    protected Scope visitJoin(Join node, Scope scope) {
        block14: {
            block15: {
                block13: {
                    criteria = node.getCriteria().orElse(null);
                    if (criteria instanceof NaturalJoin) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
                    }
                    left = (Scope)this.process((Node)node.getLeft(), scope);
                    right = (Scope)this.process((Node)node.getRight(), StatementAnalyzer.isUnnestRelation(node.getRight()) != false ? left : scope);
                    output = this.createScope((Node)node, scope, left.getRelationType().joinWith(right.getRelationType()));
                    if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
                        return output;
                    }
                    if (!(criteria instanceof JoinUsing)) break block13;
                    columns = ((JoinUsing)criteria).getColumns();
                    expressions = new ArrayList<Expression>();
                    for (String column : columns) {
                        leftExpression = new Identifier(column);
                        rightExpression = new Identifier(column);
                        leftExpressionAnalysis = this.analyzeExpression((Expression)leftExpression, left);
                        rightExpressionAnalysis = this.analyzeExpression((Expression)rightExpression, right);
                        Preconditions.checkState((boolean)leftExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                        Preconditions.checkState((boolean)rightExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                        Preconditions.checkState((boolean)leftExpressionAnalysis.getScalarSubqueries().isEmpty(), (Object)"INVARIANT");
                        Preconditions.checkState((boolean)rightExpressionAnalysis.getScalarSubqueries().isEmpty(), (Object)"INVARIANT");
                        this.addCoercionForJoinCriteria(node, (Expression)leftExpression, (Expression)rightExpression);
                        expressions.add((Expression)new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)leftExpression, (Expression)rightExpression));
                    }
                    this.analysis.setJoinCriteria(node, ExpressionUtils.and(expressions));
                    break block14;
                }
                if (!(criteria instanceof JoinOn)) break block15;
                expression = ((JoinOn)criteria).getExpression();
                analyzer = ExpressionAnalyzer.create(this.analysis, this.session, this.metadata, this.sqlParser, this.accessControl);
                clauseType = analyzer.analyze(expression, output);
                if (!clauseType.equals(BooleanType.BOOLEAN)) {
                    if (!clauseType.equals((Object)UnknownType.UNKNOWN)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, "JOIN ON clause must evaluate to a boolean: actual type %s", new Object[]{clauseType});
                    }
                    this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN, false);
                }
                Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata.getFunctionRegistry(), expression, "JOIN clause");
                canonicalized = CanonicalizeExpressions.canonicalizeExpression(expression);
                analyzer.analyze(canonicalized, output);
                optimizedExpression = ExpressionInterpreter.expressionOptimizer(canonicalized, this.metadata, this.session, analyzer.getExpressionTypes()).optimize(NoOpSymbolResolver.INSTANCE);
                if (!(optimizedExpression instanceof Expression) && (optimizedExpression instanceof Boolean || optimizedExpression == null)) {
                    optimizedExpression = optimizedExpression != null && optimizedExpression.equals(Boolean.TRUE) != false ? new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("0")) : new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("1"));
                }
                if (!(optimizedExpression instanceof Expression)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Join clause must be a boolean expression", new Object[0]);
                }
                analyzer = ExpressionAnalyzer.create(this.analysis, this.session, this.metadata, this.sqlParser, this.accessControl);
                analyzer.analyze((Expression)optimizedExpression, output);
                this.analysis.addCoercions(analyzer.getExpressionCoercions(), analyzer.getTypeOnlyCoercions());
                postJoinConjuncts = new HashSet<Expression>();
                for (Expression conjunct : ExpressionUtils.extractConjuncts((Expression)optimizedExpression)) {
                    block16: {
                        if (!((conjunct = ExpressionUtils.normalize(conjunct)) instanceof ComparisonExpression) || ((ComparisonExpression)conjunct).getType() != ComparisonExpressionType.EQUAL && node.getType() != Join.Type.INNER) break block16;
                        conjunctFirst = ((ComparisonExpression)conjunct).getLeft();
                        conjunctSecond = ((ComparisonExpression)conjunct).getRight();
                        firstDependencies = DependencyExtractor.extractNames(conjunctFirst, analyzer.getColumnReferences());
                        secondDependencies = DependencyExtractor.extractNames(conjunctSecond, analyzer.getColumnReferences());
                        leftExpression = null;
                        rightExpression = null;
                        if (!firstDependencies.stream().allMatch((Predicate<QualifiedName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, canResolve(com.facebook.presto.sql.tree.QualifiedName ), (Lcom/facebook/presto/sql/tree/QualifiedName;)Z)((RelationType)left.getRelationType()))) ** GOTO lbl-1000
                        if (secondDependencies.stream().allMatch((Predicate<QualifiedName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, canResolve(com.facebook.presto.sql.tree.QualifiedName ), (Lcom/facebook/presto/sql/tree/QualifiedName;)Z)((RelationType)right.getRelationType()))) {
                            leftExpression = conjunctFirst;
                            rightExpression = conjunctSecond;
                        } else if (firstDependencies.stream().allMatch((Predicate<QualifiedName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, canResolve(com.facebook.presto.sql.tree.QualifiedName ), (Lcom/facebook/presto/sql/tree/QualifiedName;)Z)((RelationType)right.getRelationType()))) {
                            if (secondDependencies.stream().allMatch((Predicate<QualifiedName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, canResolve(com.facebook.presto.sql.tree.QualifiedName ), (Lcom/facebook/presto/sql/tree/QualifiedName;)Z)((RelationType)left.getRelationType()))) {
                                leftExpression = conjunctSecond;
                                rightExpression = conjunctFirst;
                            }
                        }
                        if (rightExpression != null) {
                            leftExpressionAnalysis = this.analyzeExpression(leftExpression, left);
                            rightExpressionAnalysis = this.analyzeExpression(rightExpression, right);
                            this.analysis.recordSubqueries((Node)node, leftExpressionAnalysis);
                            this.analysis.recordSubqueries((Node)node, rightExpressionAnalysis);
                            this.addCoercionForJoinCriteria(node, leftExpression, rightExpression);
                            continue;
                        }
                        postJoinConjuncts.add(conjunct);
                        continue;
                    }
                    postJoinConjuncts.add(conjunct);
                }
                postJoinPredicate = ExpressionUtils.combineConjuncts(postJoinConjuncts);
                this.analysis.recordSubqueries((Node)node, this.analyzeExpression(postJoinPredicate, output));
                this.analysis.setJoinCriteria(node, (Expression)optimizedExpression);
                break block14;
            }
            throw new UnsupportedOperationException("unsupported join criteria: " + criteria.getClass().getName());
        }
        return output;
    }

    private static boolean isUnnestRelation(Relation node) {
        if (node instanceof AliasedRelation) {
            return StatementAnalyzer.isUnnestRelation(((AliasedRelation)node).getRelation());
        }
        return node instanceof Unnest;
    }

    private void addCoercionForJoinCriteria(Join node, Expression leftExpression, Expression rightExpression) {
        Type leftType = this.analysis.getTypeWithCoercions(leftExpression);
        Type rightType = this.analysis.getTypeWithCoercions(rightExpression);
        Optional superType = this.metadata.getTypeManager().getCommonSuperType(leftType, rightType);
        if (!superType.isPresent()) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Join criteria has incompatible types: %s, %s", leftType.getDisplayName(), rightType.getDisplayName());
        }
        if (!leftType.equals(superType.get())) {
            this.analysis.addCoercion(leftExpression, (Type)superType.get(), this.metadata.getTypeManager().isTypeOnlyCoercion(leftType, rightType));
        }
        if (!rightType.equals(superType.get())) {
            this.analysis.addCoercion(rightExpression, (Type)superType.get(), this.metadata.getTypeManager().isTypeOnlyCoercion(rightType, leftType));
        }
    }

    protected Scope visitValues(Values node, Scope scope) {
        Preconditions.checkState((node.getRows().size() >= 1 ? 1 : 0) != 0);
        List rowTypes = (List)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, scope).getType((Expression)row)).map(type -> {
            if (type instanceof RowType) {
                return type.getTypeParameters();
            }
            return ImmutableList.of((Object)type);
        }).collect(ImmutableCollectors.toImmutableList());
        ArrayList fieldTypes = new ArrayList((Collection)rowTypes.iterator().next());
        for (List rowType : rowTypes) {
            if (rowType.size() != fieldTypes.size()) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", rowTypes.get(0), rowType);
            }
            for (int i = 0; i < rowType.size(); ++i) {
                Type fieldType = (Type)rowType.get(i);
                Type superType = (Type)fieldTypes.get(i);
                Optional commonSuperType = this.metadata.getTypeManager().getCommonSuperType(fieldType, superType);
                if (!commonSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", rowTypes.get(0), rowType);
                }
                fieldTypes.set(i, commonSuperType.get());
            }
        }
        for (Expression row2 : node.getRows()) {
            Type expectedType;
            if (row2 instanceof Row) {
                List items = ((Row)row2).getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Type expectedType2 = (Type)fieldTypes.get(i);
                    Expression item = (Expression)items.get(i);
                    Type actualType = this.analysis.getType(item);
                    if (actualType.equals(expectedType2)) continue;
                    this.analysis.addCoercion(item, expectedType2, this.metadata.getTypeManager().isTypeOnlyCoercion(actualType, expectedType2));
                }
                continue;
            }
            Type actualType = this.analysis.getType(row2);
            if (actualType.equals(expectedType = (Type)fieldTypes.get(0))) continue;
            this.analysis.addCoercion(row2, expectedType, this.metadata.getTypeManager().isTypeOnlyCoercion(actualType, expectedType));
        }
        List fields = (List)fieldTypes.stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType)).collect(ImmutableCollectors.toImmutableList());
        return this.createScope((Node)node, scope, fields);
    }

    private void analyzeWindowFunctions(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
        WindowFunctionExtractor extractor = new WindowFunctionExtractor();
        for (Expression expression2 : Iterables.concat(outputExpressions, orderByExpressions)) {
            extractor.process((Node)expression2, null);
            new WindowFunctionValidator().process((Node)expression2, this.analysis);
        }
        List<FunctionCall> windowFunctions = extractor.getWindowFunctions();
        for (FunctionCall windowFunction : windowFunctions) {
            if (windowFunction.getFilter().isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "FILTER is not yet supported for window functions", new Object[0]);
            }
            Window window = (Window)windowFunction.getWindow().get();
            WindowFunctionExtractor nestedExtractor = new WindowFunctionExtractor();
            for (Expression argument : windowFunction.getArguments()) {
                nestedExtractor.process((Node)argument, null);
            }
            for (Expression expression3 : window.getPartitionBy()) {
                nestedExtractor.process((Node)expression3, null);
            }
            for (SortItem sortItem : window.getOrderBy()) {
                nestedExtractor.process((Node)sortItem.getSortKey(), null);
            }
            if (window.getFrame().isPresent()) {
                nestedExtractor.process((Node)window.getFrame().get(), null);
            }
            if (!nestedExtractor.getWindowFunctions().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside window function '%s': %s", windowFunction, extractor.getWindowFunctions());
            }
            if (windowFunction.isDistinct()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
            }
            if (window.getFrame().isPresent()) {
                StatementAnalyzer.analyzeWindowFrame((WindowFrame)window.getFrame().get());
            }
            List argumentTypes = Lists.transform((List)windowFunction.getArguments(), expression -> this.analysis.getType((Expression)expression).getTypeSignature());
            FunctionKind kind = this.metadata.getFunctionRegistry().resolveFunction(windowFunction.getName(), TypeSignatureProvider.fromTypeSignatures(argumentTypes)).getKind();
            if (kind == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) continue;
            throw new SemanticException(SemanticErrorCode.MUST_BE_WINDOW_FUNCTION, (Node)node, "Not a window function: %s", windowFunction.getName());
        }
        this.analysis.setWindowFunctions(node, windowFunctions);
    }

    private static void analyzeWindowFrame(WindowFrame frame) {
        FrameBound.Type startType = frame.getStart().getType();
        FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
        if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
        }
        if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
        }
        if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.PRECEDING || endType == FrameBound.Type.PRECEDING)) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE PRECEDING is only supported with UNBOUNDED", new Object[0]);
        }
        if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.FOLLOWING || endType == FrameBound.Type.FOLLOWING)) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE FOLLOWING is only supported with UNBOUNDED", new Object[0]);
        }
    }

    private void analyzeHaving(QuerySpecification node, Scope scope) {
        if (node.getHaving().isPresent()) {
            Expression predicate = (Expression)node.getHaving().get();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
            this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN) && !predicateType.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", predicateType);
            }
            this.analysis.setHaving(node, predicate);
        }
    }

    private List<Expression> analyzeOrderBy(QuerySpecification node, Scope sourceScope, Scope outputScope, List<Expression> outputExpressions) {
        if (SystemSessionProperties.isLegacyOrderByEnabled(this.session)) {
            return this.legacyAnalyzeOrderBy(node, sourceScope, outputScope, outputExpressions);
        }
        List items = node.getOrderBy();
        ImmutableList.Builder orderByExpressionsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            for (SortItem item : items) {
                Expression orderByExpression;
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    int field = Math.toIntExact(ordinal - 1L);
                    Type type = outputScope.getRelationType().getFieldByIndex(field).getType();
                    if (!type.isOrderable()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "The type of expression in position %s is not orderable (actual: %s), and therefore cannot be used in ORDER BY", ordinal, type);
                    }
                    orderByExpression = outputExpressions.get(field);
                } else {
                    Scope synthetic = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationType()).build();
                    this.analyzeExpression(expression, synthetic);
                    orderByExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new OrderByExpressionRewriter(StatementAnalyzer.extractNamedOutputExpressions(node)), (Expression)expression);
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(orderByExpression, sourceScope);
                    this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                }
                Type type = this.analysis.getType(orderByExpression);
                if (!type.isOrderable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                }
                orderByExpressionsBuilder.add((Object)orderByExpression);
            }
        }
        ImmutableList orderByExpressions = orderByExpressionsBuilder.build();
        this.analysis.setOrderByExpressions((Node)node, (List<Expression>)orderByExpressions);
        if (node.getSelect().isDistinct() && !outputExpressions.containsAll((Collection<?>)orderByExpressions)) {
            throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
        }
        return orderByExpressions;
    }

    private List<Expression> legacyAnalyzeOrderBy(QuerySpecification node, Scope sourceScope, Scope outputScope, List<Expression> outputExpressions) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByExpressionsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            ImmutableMultimap.Builder byAliasBuilder = ImmutableMultimap.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                Optional alias;
                if (!(item instanceof SingleColumn) || !(alias = ((SingleColumn)item).getAlias()).isPresent()) continue;
                byAliasBuilder.put((Object)QualifiedName.of((String)((String)alias.get())), (Object)((SingleColumn)item).getExpression());
            }
            ImmutableMultimap byAlias = byAliasBuilder.build();
            for (SortItem item : items) {
                Expression expression = item.getSortKey();
                Expression orderByExpression = null;
                if (expression instanceof Identifier) {
                    QualifiedName name = QualifiedName.of((String)((Identifier)expression).getName());
                    Collection expressions = byAlias.get((Object)name);
                    if (expressions.size() > 1) {
                        throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)expression, "'%s' in ORDER BY is ambiguous", name.getSuffix());
                    }
                    if (expressions.size() == 1) {
                        orderByExpression = (Expression)Iterables.getOnlyElement((Iterable)expressions);
                    }
                } else if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    int field = Math.toIntExact(ordinal - 1L);
                    Type type = outputScope.getRelationType().getFieldByIndex(field).getType();
                    if (!type.isOrderable()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "The type of expression in position %s is not orderable (actual: %s), and therefore cannot be used in ORDER BY", ordinal, type);
                    }
                    orderByExpression = outputExpressions.get(field);
                }
                if (orderByExpression == null) {
                    orderByExpression = expression;
                }
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(orderByExpression, sourceScope);
                this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                Type type = expressionAnalysis.getType(orderByExpression);
                if (!type.isOrderable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                }
                orderByExpressionsBuilder.add((Object)orderByExpression);
            }
        }
        ImmutableList orderByExpressions = orderByExpressionsBuilder.build();
        this.analysis.setOrderByExpressions((Node)node, (List<Expression>)orderByExpressions);
        if (node.getSelect().isDistinct() && !outputExpressions.containsAll((Collection<?>)orderByExpressions)) {
            throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
        }
        return orderByExpressions;
    }

    private static Multimap<QualifiedName, Expression> extractNamedOutputExpressions(QuerySpecification node) {
        ImmutableMultimap.Builder assignments = ImmutableMultimap.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (!(item instanceof SingleColumn)) continue;
            SingleColumn column = (SingleColumn)item;
            Optional alias = column.getAlias();
            if (alias.isPresent()) {
                assignments.put((Object)QualifiedName.of((String)((String)alias.get())), (Object)column.getExpression());
                continue;
            }
            if (!(column.getExpression() instanceof Identifier)) continue;
            assignments.put((Object)QualifiedName.of((String)((Identifier)column.getExpression()).getName()), (Object)column.getExpression());
        }
        return assignments.build();
    }

    private List<List<Expression>> analyzeGroupBy(QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
        Object computedGroupingSets = ImmutableList.of();
        if (node.getGroupBy().isPresent()) {
            List enumeratedGroupingSets = (List)((GroupBy)node.getGroupBy().get()).getGroupingElements().stream().map(GroupingElement::enumerateGroupingSets).collect(ImmutableCollectors.toImmutableList());
            computedGroupingSets = StatementAnalyzer.computeGroupingSetsCrossProduct(enumeratedGroupingSets, ((GroupBy)node.getGroupBy().get()).isDistinct());
            Preconditions.checkState((!computedGroupingSets.isEmpty() ? 1 : 0) != 0, (Object)"computed grouping sets cannot be empty");
        } else if (this.hasAggregates(node)) {
            computedGroupingSets = ImmutableList.of((Object)ImmutableSet.of());
        }
        List analyzedGroupingSets = (List)computedGroupingSets.stream().map(groupingSet -> this.analyzeGroupingColumns((Set<Expression>)groupingSet, node, scope, outputExpressions)).collect(ImmutableCollectors.toImmutableList());
        this.analysis.setGroupingSets(node, analyzedGroupingSets);
        return analyzedGroupingSets;
    }

    private static List<Set<Expression>> computeGroupingSetsCrossProduct(List<List<Set<Expression>>> enumeratedGroupingSets, boolean isDistinct) {
        Preconditions.checkState((!enumeratedGroupingSets.isEmpty() ? 1 : 0) != 0, (Object)"enumeratedGroupingSets cannot be empty");
        ArrayList<Set<Expression>> groupingSetsCrossProduct = new ArrayList<Set<Expression>>();
        enumeratedGroupingSets.get(0).stream().map(ImmutableSet::copyOf).forEach(groupingSetsCrossProduct::add);
        for (int i = 1; i < enumeratedGroupingSets.size(); ++i) {
            List<Set<Expression>> groupingSets = enumeratedGroupingSets.get(i);
            ImmutableList oldGroupingSetsCrossProduct = ImmutableList.copyOf(groupingSetsCrossProduct);
            groupingSetsCrossProduct.clear();
            for (Set existingSet : oldGroupingSetsCrossProduct) {
                for (Set<Expression> groupingSet : groupingSets) {
                    ImmutableSet concatenatedSet = ImmutableSet.builder().addAll((Iterable)existingSet).addAll(groupingSet).build();
                    groupingSetsCrossProduct.add((Set<Expression>)concatenatedSet);
                }
            }
        }
        if (isDistinct) {
            return ImmutableList.copyOf((Collection)ImmutableSet.copyOf(groupingSetsCrossProduct));
        }
        return groupingSetsCrossProduct;
    }

    private List<Expression> analyzeGroupingColumns(Set<Expression> groupingColumns, QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
        ImmutableList.Builder groupingColumnsBuilder = ImmutableList.builder();
        for (Expression groupingColumn : groupingColumns) {
            Expression groupByExpression;
            if (groupingColumn instanceof LongLiteral) {
                long ordinal = ((LongLiteral)groupingColumn).getValue();
                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                    throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)groupingColumn, "GROUP BY position %s is not in select list", ordinal);
                }
                groupByExpression = outputExpressions.get(Math.toIntExact(ordinal - 1L));
            } else {
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(groupingColumn, scope);
                this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                groupByExpression = groupingColumn;
            }
            Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata.getFunctionRegistry(), groupByExpression, "GROUP BY clause");
            Type type = this.analysis.getType(groupByExpression);
            if (!type.isComparable()) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", type);
            }
            groupingColumnsBuilder.add((Object)groupByExpression);
        }
        return groupingColumnsBuilder.build();
    }

    private Scope computeOutputScope(QuerySpecification node, Scope scope) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                for (Field field : scope.getRelationType().resolveFieldsWithPrefix(starPrefix)) {
                    outputFields.add((Object)Field.newUnqualified(field.getName(), field.getType(), field.getOriginTable(), false));
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                List<Field> matchingFields;
                SingleColumn column = (SingleColumn)item;
                Expression expression = column.getExpression();
                Optional<Object> fieldName = column.getAlias();
                Optional<QualifiedObjectName> originTable = Optional.empty();
                QualifiedName name = null;
                if (expression instanceof Identifier) {
                    name = QualifiedName.of((String)((Identifier)expression).getName());
                } else if (expression instanceof DereferenceExpression) {
                    name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
                }
                if (name != null && !(matchingFields = scope.getRelationType().resolveFields(name)).isEmpty()) {
                    originTable = matchingFields.get(0).getOriginTable();
                }
                if (!fieldName.isPresent() && name != null) {
                    fieldName = Optional.of(Iterables.getLast((Iterable)name.getOriginalParts()));
                }
                outputFields.add((Object)Field.newUnqualified(fieldName, this.analysis.getType(expression), originTable, column.getAlias().isPresent()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        return this.createScope((Node)node, scope, (List<Field>)outputFields.build());
    }

    private List<Expression> analyzeSelect(QuerySpecification node, Scope scope) {
        ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                RelationType relationType = scope.getRelationType();
                List<Field> fields = relationType.resolveFieldsWithPrefix(starPrefix);
                if (fields.isEmpty()) {
                    if (starPrefix.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)item, "Table '%s' not found", starPrefix.get());
                    }
                    throw new SemanticException(SemanticErrorCode.WILDCARD_WITHOUT_FROM, (Node)item, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                }
                for (Field field : fields) {
                    int fieldIndex = relationType.indexOf(field);
                    FieldReference expression = new FieldReference(fieldIndex);
                    outputExpressionBuilder.add((Object)expression);
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression((Expression)expression, scope);
                    Type type = expressionAnalysis.getType((Expression)expression);
                    if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", type);
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(column.getExpression(), scope);
                this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                outputExpressionBuilder.add((Object)column.getExpression());
                Type type = expressionAnalysis.getType(column.getExpression());
                if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", type, column.getExpression());
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        ImmutableList result = outputExpressionBuilder.build();
        this.analysis.setOutputExpressions((Node)node, (List<Expression>)result);
        return result;
    }

    public void analyzeWhere(Node node, Scope scope, Expression predicate) {
        Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata.getFunctionRegistry(), predicate, "WHERE clause");
        ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
        this.analysis.recordSubqueries(node, expressionAnalysis);
        Type predicateType = expressionAnalysis.getType(predicate);
        if (!predicateType.equals(BooleanType.BOOLEAN)) {
            if (!predicateType.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", predicateType);
            }
            this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN, false);
        }
        this.analysis.setWhere(node, predicate);
    }

    private Scope analyzeFrom(QuerySpecification node, Scope scope) {
        if (node.getFrom().isPresent()) {
            return (Scope)this.process((Node)node.getFrom().get(), scope);
        }
        return scope;
    }

    private void analyzeAggregations(QuerySpecification node, Scope scope, List<List<Expression>> groupingSets, Set<Expression> columnReferences, List<Expression> expressions) {
        AggregateExtractor extractor = new AggregateExtractor(this.metadata.getFunctionRegistry());
        for (Expression expression : expressions) {
            extractor.process((Node)expression);
        }
        this.analysis.setAggregates(node, extractor.getAggregates());
        if (!groupingSets.isEmpty()) {
            ImmutableList distinctGroupingColumns = groupingSets.stream().flatMap(Collection::stream).distinct().collect(ImmutableCollectors.toImmutableList());
            for (Expression expression : expressions) {
                this.verifyAggregations((List<Expression>)distinctGroupingColumns, scope, expression, columnReferences);
            }
        }
    }

    private boolean hasAggregates(QuerySpecification node) {
        AggregateExtractor extractor = new AggregateExtractor(this.metadata.getFunctionRegistry());
        node.getSelect().getSelectItems().stream().filter(SingleColumn.class::isInstance).forEach(arg_0 -> ((AggregateExtractor)extractor).process(arg_0));
        node.getOrderBy().stream().forEach(arg_0 -> ((AggregateExtractor)extractor).process(arg_0));
        node.getHaving().ifPresent(arg_0 -> ((AggregateExtractor)extractor).process(arg_0));
        return !extractor.getAggregates().isEmpty();
    }

    private void verifyAggregations(List<Expression> groupByExpressions, Scope scope, Expression expression, Set<Expression> columnReferences) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, this.metadata, scope, columnReferences, this.analysis.getParameters(), this.analysis.isDescribe());
        analyzer.analyze(expression);
    }

    private RelationType analyzeView(Query query, QualifiedObjectName name, Optional<String> catalog, Optional<String> schema, Optional<String> owner, Table node) {
        try {
            AccessControl viewAccessControl;
            Identity identity;
            if (owner.isPresent()) {
                identity = new Identity(owner.get(), Optional.empty());
                viewAccessControl = new ViewAccessControl(this.accessControl);
            } else {
                identity = this.session.getIdentity();
                viewAccessControl = this.accessControl;
            }
            Session viewSession = Session.builder(this.metadata.getSessionPropertyManager()).setQueryId(this.session.getQueryId()).setTransactionId(this.session.getTransactionId().orElse(null)).setIdentity(identity).setSource(this.session.getSource().orElse(null)).setCatalog(catalog.orElse(null)).setSchema(schema.orElse(null)).setTimeZoneKey(this.session.getTimeZoneKey()).setLocale(this.session.getLocale()).setRemoteUserAddress(this.session.getRemoteUserAddress().orElse(null)).setUserAgent(this.session.getUserAgent().orElse(null)).setClientInfo(this.session.getClientInfo().orElse(null)).setStartTime(this.session.getStartTime()).setSystemProperty("legacy_order_by", this.session.getSystemProperty("legacy_order_by", Boolean.class).toString()).build();
            StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, viewAccessControl, viewSession);
            Scope queryScope = (Scope)analyzer.process((Node)query, Scope.create());
            return queryScope.getRelationType().withAlias(name.getObjectName(), null);
        }
        catch (RuntimeException e) {
            throw new SemanticException(SemanticErrorCode.VIEW_ANALYSIS_ERROR, (Node)node, "Failed analyzing stored view '%s': %s", name, e.getMessage());
        }
    }

    private Query parseView(String view, QualifiedObjectName name, Node node) {
        try {
            Statement statement = this.sqlParser.createStatement(view);
            return Types.checkType(statement, Query.class, "parsed view");
        }
        catch (ParsingException e) {
            throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, node, "Failed parsing stored view '%s': %s", name, e.getMessage());
        }
    }

    private boolean isViewStale(List<ViewDefinition.ViewColumn> columns, Collection<Field> fields) {
        if (columns.size() != fields.size()) {
            return true;
        }
        ImmutableList fieldList = ImmutableList.copyOf(fields);
        for (int i = 0; i < columns.size(); ++i) {
            ViewDefinition.ViewColumn column = columns.get(i);
            Field field = (Field)fieldList.get(i);
            if (column.getName().equalsIgnoreCase(field.getName().orElse(null)) && this.metadata.getTypeManager().canCoerce(field.getType(), column.getType())) continue;
            return true;
        }
        return false;
    }

    private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope) {
        return ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.accessControl, this.sqlParser, scope, this.analysis, expression);
    }

    private List<Expression> descriptorToFields(Scope scope) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int fieldIndex = 0; fieldIndex < scope.getRelationType().getAllFieldCount(); ++fieldIndex) {
            FieldReference expression = new FieldReference(fieldIndex);
            builder.add((Object)expression);
            this.analyzeExpression((Expression)expression, scope);
        }
        return builder.build();
    }

    private Scope analyzeWith(Query node, Scope scope) {
        if (!node.getWith().isPresent()) {
            return scope;
        }
        With with = (With)node.getWith().get();
        if (with.isRecursive()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)with, "Recursive WITH queries are not supported", new Object[0]);
        }
        Scope.Builder withScopeBuilder = Scope.builder().withParent(scope);
        for (WithQuery withQuery : with.getQueries()) {
            Query query = withQuery.getQuery();
            this.process((Node)query, withScopeBuilder.build());
            String name = withQuery.getName();
            if (withScopeBuilder.containsNamedQuery(name)) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)withQuery, "WITH query name '%s' specified more than once", name);
            }
            if (withQuery.getColumnNames().isPresent()) {
                List columnNames = (List)withQuery.getColumnNames().get();
                RelationType queryDescriptor = this.analysis.getOutputDescriptor((Node)query);
                if (columnNames.size() != queryDescriptor.getVisibleFieldCount()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)withQuery, "WITH column alias list has %s entries but WITH query(%s) has %s columns", columnNames.size(), name, queryDescriptor.getVisibleFieldCount());
                }
            }
            withScopeBuilder.withNamedQuery(name, withQuery);
        }
        Scope withScope = withScopeBuilder.build();
        this.analysis.setScope((Node)with, withScope);
        return withScope;
    }

    private void analyzeOrderBy(Query node, Scope scope) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
        for (SortItem item : items) {
            Expression expression = item.getSortKey();
            if (expression instanceof LongLiteral) {
                long ordinal = ((LongLiteral)expression).getValue();
                if (ordinal < 1L || ordinal > (long)scope.getRelationType().getVisibleFieldCount()) {
                    throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                }
                expression = new FieldReference(Math.toIntExact(ordinal - 1L));
            }
            ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.accessControl, this.sqlParser, scope, this.analysis, expression);
            this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            orderByFieldsBuilder.add((Object)expression);
        }
        this.analysis.setOrderByExpressions((Node)node, (List<Expression>)orderByFieldsBuilder.build());
    }

    public Scope createScope(Node node, Scope parent, Field ... fields) {
        return this.createScope(node, parent, new RelationType(fields));
    }

    public Scope createScope(Node node, Scope parent, List<Field> fields) {
        return this.createScope(node, parent, new RelationType(fields));
    }

    public Scope createScope(Node node, Scope parent, RelationType relationType) {
        Scope scope = Scope.builder().withParent(parent).withRelationType(relationType).build();
        this.analysis.setScope(node, scope);
        return scope;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    private static /* synthetic */ Field lambda$visitTable$5(QualifiedObjectName name, ViewDefinition.ViewColumn column) {
        return Field.newQualified(QualifiedName.of((String)name.getObjectName()), Optional.of(column.getName()), column.getType(), false, Optional.of(name), false);
    }

    private static /* synthetic */ Field lambda$visitTable$4(String name, Field field) {
        return Field.newQualified(QualifiedName.of((String)name), field.getName(), field.getType(), field.isHidden(), field.getOriginTable(), field.isAliased());
    }

    private static class OrderByExpressionRewriter
    extends ExpressionRewriter<Void> {
        private final Multimap<QualifiedName, Expression> assignments;

        public OrderByExpressionRewriter(Multimap<QualifiedName, Expression> assignments) {
            this.assignments = assignments;
        }

        public Expression rewriteIdentifier(Identifier reference, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            QualifiedName name = QualifiedName.of((String)reference.getName());
            Set expressions = this.assignments.get((Object)name).stream().collect(Collectors.toSet());
            if (expressions.size() > 1) {
                throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)reference, "'%s' in ORDER BY is ambiguous", name);
            }
            if (expressions.size() == 1) {
                return (Expression)Iterables.getOnlyElement(expressions);
            }
            return reference;
        }
    }
}

