/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;

public final class SemanticExceptions {
    private SemanticExceptions() {
    }

    public static SemanticException missingAttributeException(Expression node, QualifiedName name) {
        throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", name);
    }

    @Deprecated
    public static SemanticException missingAttributeException(Expression node) {
        throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", node);
    }

    public static SemanticException ambiguousAttributeException(Expression node, QualifiedName name) {
        throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)node, "Column '%s' is ambiguous", name);
    }

    public static SemanticException notSupportedException(Node node, String notSupportedFeatureDescription) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, node, notSupportedFeatureDescription + " is not supported", new Object[0]);
    }
}

