/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Analyzer {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;
    private final List<Expression> parameters;

    public Analyzer(Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, List<Expression> parameters) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "query explainer is null");
        this.parameters = parameters;
    }

    public Analysis analyze(Statement statement) {
        return this.analyze(statement, false);
    }

    public Analysis analyze(Statement statement, boolean isDescribe) {
        Statement rewrittenStatement = StatementRewrite.rewrite(this.session, this.metadata, this.sqlParser, this.queryExplainer, statement, this.parameters, this.accessControl);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameters, isDescribe);
        StatementAnalyzer analyzer = new StatementAnalyzer(analysis, this.metadata, this.sqlParser, this.accessControl, this.session);
        analyzer.process((Node)rewrittenStatement, Scope.create());
        return analysis;
    }

    static void verifyNoAggregatesOrWindowFunctions(FunctionRegistry functionRegistry, Expression predicate, String clause) {
        AggregateExtractor extractor = new AggregateExtractor(functionRegistry);
        extractor.process((Node)predicate, null);
        WindowFunctionExtractor windowExtractor = new WindowFunctionExtractor();
        windowExtractor.process((Node)predicate, null);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(extractor.getAggregates(), windowExtractor.getWindowFunctions()));
        if (!found.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, (Node)predicate, "%s cannot contain aggregations or window functions: %s", clause, found);
        }
    }
}

