/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.spi.QueryId;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
public class QueryExecutionResource {
    private static final TaskId OUTPUT_TASK_ID = new TaskId("output_buffer", 0, 0);
    private final QueryManager manager;

    @Inject
    public QueryExecutionResource(QueryManager manager) {
        Objects.requireNonNull(manager, "manager is null");
        this.manager = manager;
    }

    @GET
    @Path(value="/ui/plan")
    @Produces(value={"text/html"})
    public String getPlanUi() throws IOException {
        return Resources.toString((URL)Resources.getResource(this.getClass(), (String)"plan.html"), (Charset)StandardCharsets.UTF_8);
    }

    @GET
    @Path(value="/ui/query-execution")
    @Produces(value={"text/html"})
    public String getUi() throws IOException {
        return Resources.toString((URL)Resources.getResource(this.getClass(), (String)"query-execution.html"), (Charset)StandardCharsets.UTF_8);
    }

    @GET
    @Path(value="/v1/query-execution/{queryId}")
    @Produces(value={"application/json"})
    public Response getTaskInfo(@PathParam(value="queryId") String queryId) {
        QueryInfo query;
        try {
            query = this.manager.getQueryInfo(QueryId.valueOf((String)queryId));
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List<StageInfo> stages = QueryExecutionResource.collectStages(query.getOutputStage());
        ArrayList<Task> tasks = new ArrayList<Task>();
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (StageInfo stage : stages) {
            for (TaskInfo task : stage.getTasks()) {
                int bufferedPages = 0;
                TaskStatus taskStatus = task.getTaskStatus();
                for (BufferInfo bufferInfo : task.getOutputBuffers().getBuffers()) {
                    bufferedPages += bufferInfo.getBufferedPages();
                    if (bufferInfo.getBufferId().equals(OUTPUT_TASK_ID)) continue;
                    flows.add(new Flow(taskStatus.getTaskId().toString(), bufferInfo.getBufferId().toString(), bufferInfo.getPageBufferInfo().getPagesAdded(), bufferInfo.getBufferedPages(), bufferInfo.isFinished()));
                }
                long last = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                if (task.getStats().getEndTime() != null) {
                    last = task.getStats().getEndTime().getMillis();
                }
                tasks.add(new Task(taskStatus.getTaskId().toString(), taskStatus.getState().toString(), taskStatus.getSelf().getHost(), last - task.getStats().getCreateTime().getMillis(), task.getStats().getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS), task.getStats().getTotalBlockedTime().roundTo(TimeUnit.MILLISECONDS), task.getStats().getRawInputDataSize().roundTo(DataSize.Unit.BYTE), task.getStats().getRawInputPositions(), task.getStats().getOutputDataSize().roundTo(DataSize.Unit.BYTE), task.getStats().getOutputPositions(), task.getStats().getMemoryReservation().roundTo(DataSize.Unit.BYTE), task.getStats().getQueuedDrivers(), task.getStats().getRunningDrivers(), task.getStats().getCompletedDrivers(), bufferedPages));
            }
        }
        ImmutableMap result = ImmutableMap.builder().put((Object)"tasks", tasks).put((Object)"flows", flows).build();
        return Response.ok((Object)result).build();
    }

    private static List<StageInfo> collectStages(Optional<StageInfo> stage) {
        ImmutableList.Builder result = ImmutableList.builder();
        QueryExecutionResource.collectStages(stage, (ImmutableList.Builder<StageInfo>)result);
        return result.build();
    }

    private static void collectStages(Optional<StageInfo> stageInfo, ImmutableList.Builder<StageInfo> result) {
        stageInfo.ifPresent(stage -> {
            result.add(stage);
            stage.getSubStages().stream().forEach(subStage -> QueryExecutionResource.collectStages(Optional.ofNullable(subStage), result));
        });
    }

    public static class Task {
        private final String taskId;
        private final String state;
        private final String host;
        private final long uptime;
        private final long cpuMillis;
        private final long blockedMillis;
        private final long inputBytes;
        private final long inputRows;
        private final long outputBytes;
        private final long outputRows;
        private final long usedMemoryBytes;
        private final int queuedSplits;
        private final int runningSplits;
        private final int completedSplits;
        private final int bufferedPages;

        public Task(String taskId, String state, String host, long uptimeMillis, long cpuMillis, long blockedMillis, long inputBytes, long inputRows, long outputBytes, long outputRows, long usedMemoryBytes, int queuedSplits, int runningSplits, int completedSplits, int bufferedPages) {
            this.taskId = taskId;
            this.state = state;
            this.host = host;
            this.uptime = uptimeMillis;
            this.cpuMillis = cpuMillis;
            this.blockedMillis = blockedMillis;
            this.inputBytes = inputBytes;
            this.inputRows = inputRows;
            this.outputBytes = outputBytes;
            this.outputRows = outputRows;
            this.usedMemoryBytes = usedMemoryBytes;
            this.queuedSplits = queuedSplits;
            this.runningSplits = runningSplits;
            this.completedSplits = completedSplits;
            this.bufferedPages = bufferedPages;
        }

        @JsonProperty
        public String getTaskId() {
            return this.taskId;
        }

        @JsonProperty
        public String getState() {
            return this.state;
        }

        @JsonProperty
        public String getHost() {
            return this.host;
        }

        @JsonProperty
        public long getUptime() {
            return this.uptime;
        }

        @JsonProperty
        public long getCpuMillis() {
            return this.cpuMillis;
        }

        @JsonProperty
        public long getBlockedMillis() {
            return this.blockedMillis;
        }

        @JsonProperty
        public long getInputBytes() {
            return this.inputBytes;
        }

        @JsonProperty
        public long getInputRows() {
            return this.inputRows;
        }

        @JsonProperty
        public long getOutputBytes() {
            return this.outputBytes;
        }

        @JsonProperty
        public long getOutputRows() {
            return this.outputRows;
        }

        @JsonProperty
        public long getUsedMemoryBytes() {
            return this.usedMemoryBytes;
        }

        @JsonProperty
        public int getQueuedSplits() {
            return this.queuedSplits;
        }

        @JsonProperty
        public int getRunningSplits() {
            return this.runningSplits;
        }

        @JsonProperty
        public int getCompletedSplits() {
            return this.completedSplits;
        }

        @JsonProperty
        public int getBufferedPages() {
            return this.bufferedPages;
        }
    }

    public static class Flow {
        private final String from;
        private final String to;
        private final long pagesSent;
        private final int bufferedPages;
        private final boolean finished;

        public Flow(String from, String to, long pagesSent, int bufferedPages, boolean finished) {
            this.from = from;
            this.to = to;
            this.pagesSent = pagesSent;
            this.bufferedPages = bufferedPages;
            this.finished = finished;
        }

        @JsonProperty
        public String getFrom() {
            return this.from;
        }

        @JsonProperty
        public String getTo() {
            return this.to;
        }

        @JsonProperty
        public long getPagesSent() {
            return this.pagesSent;
        }

        @JsonProperty
        public int getBufferedPages() {
            return this.bufferedPages;
        }

        @JsonProperty
        public boolean isFinished() {
            return this.finished;
        }
    }
}

