/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;

public final class ArrayJoin
extends SqlScalarFunction {
    public static final ArrayJoin ARRAY_JOIN = new ArrayJoin();
    public static final ArrayJoinWithNullReplacement ARRAY_JOIN_WITH_NULL_REPLACEMENT = new ArrayJoinWithNullReplacement();
    private static final TypeSignature VARCHAR_TYPE_SIGNATURE = VarcharType.VARCHAR.getTypeSignature();
    private static final String FUNCTION_NAME = "array_join";
    private static final String DESCRIPTION = "Concatenates the elements of the given array using a delimiter and an optional string to replace nulls";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", MethodHandle.class, ConnectorSession.class, Block.class, Slice.class);
    private static final MethodHandle GET_BOOLEAN = Reflection.methodHandle(Type.class, "getBoolean", Block.class, Integer.TYPE);
    private static final MethodHandle GET_DOUBLE = Reflection.methodHandle(Type.class, "getDouble", Block.class, Integer.TYPE);
    private static final MethodHandle GET_LONG = Reflection.methodHandle(Type.class, "getLong", Block.class, Integer.TYPE);
    private static final MethodHandle GET_SLICE = Reflection.methodHandle(Type.class, "getSlice", Block.class, Integer.TYPE);

    public ArrayJoin() {
        super(new Signature(FUNCTION_NAME, FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"varchar"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"varchar")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        return ArrayJoin.specializeArrayJoin(boundVariables.getTypeVariables(), functionRegistry, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE);
    }

    private static ScalarFunctionImplementation specializeArrayJoin(Map<String, Type> types, FunctionRegistry functionRegistry, List<Boolean> nullableArguments, MethodHandle methodHandle) {
        Type type = types.get("T");
        if (type instanceof UnknownType) {
            return new ScalarFunctionImplementation(false, nullableArguments, methodHandle.bindTo(null), true);
        }
        try {
            MethodHandle getter;
            ScalarFunctionImplementation castFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.CAST.name(), VARCHAR_TYPE_SIGNATURE, (List<TypeSignature>)ImmutableList.of((Object)type.getTypeSignature())));
            Class elementType = type.getJavaType();
            if (elementType == Boolean.TYPE) {
                getter = GET_BOOLEAN;
            } else if (elementType == Double.TYPE) {
                getter = GET_DOUBLE;
            } else if (elementType == Long.TYPE) {
                getter = GET_LONG;
            } else if (elementType == Slice.class) {
                getter = GET_SLICE;
            } else {
                throw new UnsupportedOperationException("Unsupported type: " + elementType.getClass().getName());
            }
            MethodHandle cast = castFunction.getMethodHandle();
            if (cast.type().parameterArray()[0] != ConnectorSession.class) {
                cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
            }
            cast = MethodHandles.permuteArguments(cast, MethodType.methodType(Slice.class, cast.type().parameterArray()[1], cast.type().parameterArray()[0]), 1, 0);
            cast = MethodHandles.dropArguments(cast, 1, new Class[]{Integer.TYPE});
            cast = MethodHandles.dropArguments(cast, 1, new Class[]{Block.class});
            cast = MethodHandles.foldArguments(cast, getter.bindTo(type));
            MethodHandle target = MethodHandles.insertArguments(methodHandle, 0, cast);
            return new ScalarFunctionImplementation(false, nullableArguments, target, true);
        }
        catch (PrestoException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Input type %s not supported", type), (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice arrayJoin(MethodHandle castFunction, ConnectorSession session, Block arrayBlock, Slice delimiter) {
        return ArrayJoin.arrayJoin(castFunction, session, arrayBlock, delimiter, null);
    }

    @UsedByGeneratedCode
    public static Slice arrayJoin(MethodHandle castFunction, ConnectorSession session, Block arrayBlock, Slice delimiter, Slice nullReplacement) {
        int numElements = arrayBlock.getPositionCount();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(arrayBlock.getSizeInBytes() + delimiter.length() * arrayBlock.getPositionCount());
        for (int i = 0; i < numElements; ++i) {
            if (arrayBlock.isNull(i)) {
                if (nullReplacement == null) continue;
                sliceOutput.appendBytes(nullReplacement);
            } else {
                try {
                    sliceOutput.appendBytes(castFunction.invokeExact(arrayBlock, i, session));
                }
                catch (Throwable throwable) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error casting array element to VARCHAR", throwable);
                }
            }
            if (i == numElements - 1) continue;
            sliceOutput.appendBytes(delimiter);
        }
        return sliceOutput.slice();
    }

    public static class ArrayJoinWithNullReplacement
    extends SqlScalarFunction {
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", MethodHandle.class, ConnectorSession.class, Block.class, Slice.class, Slice.class);

        public ArrayJoinWithNullReplacement() {
            super(new Signature(ArrayJoin.FUNCTION_NAME, FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"varchar"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"varchar"), (Object)TypeSignature.parseTypeSignature((String)"varchar")), false));
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeterministic() {
            return true;
        }

        @Override
        public String getDescription() {
            return ArrayJoin.DESCRIPTION;
        }

        @Override
        public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return ArrayJoin.specializeArrayJoin(boundVariables.getTypeVariables(), functionRegistry, (List)ImmutableList.of((Object)false, (Object)false, (Object)false), ArrayJoinWithNullReplacement.METHOD_HANDLE);
        }
    }
}

