/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.lang.invoke.MethodHandle;
import java.util.List;

@ScalarFunction(value="array_intersect")
@Description(value="Intersects elements of the two given arrays")
public final class ArrayIntersectFunction {
    private static final int INITIAL_SIZE = 128;
    private int[] leftPositions = new int[128];
    private int[] rightPositions = new int[128];
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayIntersectFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    private static IntComparator intBlockCompare(final Type type, final Block block) {
        return new AbstractIntComparator(){

            public int compare(int left, int right) {
                if (block.isNull(left) && block.isNull(right)) {
                    return 0;
                }
                if (block.isNull(left)) {
                    return -1;
                }
                if (block.isNull(right)) {
                    return 1;
                }
                return type.compareTo(block, left, block, right);
            }
        };
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block intersect(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0) {
            return leftArray;
        }
        if (rightPositionCount == 0) {
            return rightArray;
        }
        if (this.leftPositions.length < leftPositionCount) {
            this.leftPositions = new int[leftPositionCount];
        }
        if (this.rightPositions.length < rightPositionCount) {
            this.rightPositions = new int[rightPositionCount];
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        for (i = 0; i < leftPositionCount; ++i) {
            this.leftPositions[i] = i;
        }
        for (i = 0; i < rightPositionCount; ++i) {
            this.rightPositions[i] = i;
        }
        IntArrays.quickSort((int[])this.leftPositions, (int)0, (int)leftPositionCount, (IntComparator)ArrayIntersectFunction.intBlockCompare(type, leftArray));
        IntArrays.quickSort((int[])this.rightPositions, (int)0, (int)rightPositionCount, (IntComparator)ArrayIntersectFunction.intBlockCompare(type, rightArray));
        BlockBuilder resultBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        int leftCurrentPosition = 0;
        int rightCurrentPosition = 0;
        int totalCount = 0;
        while (leftCurrentPosition < leftPositionCount && rightCurrentPosition < rightPositionCount) {
            int leftBasePosition = leftCurrentPosition;
            int rightBasePosition = rightCurrentPosition;
            int compareValue = type.compareTo(leftArray, this.leftPositions[leftCurrentPosition], rightArray, this.rightPositions[rightCurrentPosition]);
            if (compareValue > 0) {
                ++rightCurrentPosition;
                continue;
            }
            if (compareValue < 0) {
                ++leftCurrentPosition;
                continue;
            }
            type.appendTo(leftArray, this.leftPositions[leftCurrentPosition], resultBlockBuilder);
            ++leftCurrentPosition;
            ++rightCurrentPosition;
            ++totalCount;
            while (leftCurrentPosition < leftPositionCount && type.equalTo(leftArray, this.leftPositions[leftBasePosition], leftArray, this.leftPositions[leftCurrentPosition])) {
                ++leftCurrentPosition;
            }
            while (rightCurrentPosition < rightPositionCount && type.equalTo(rightArray, this.rightPositions[rightBasePosition], rightArray, this.rightPositions[rightCurrentPosition])) {
                ++rightCurrentPosition;
            }
        }
        this.pageBuilder.declarePositions(totalCount);
        return resultBlockBuilder.getRegion(resultBlockBuilder.getPositionCount() - totalCount, totalCount);
    }
}

