/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class ArrayFilterFunction
extends SqlScalarFunction {
    public static final ArrayFilterFunction ARRAY_FILTER_FUNCTION = new ArrayFilterFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayFilterFunction.class, "filter", Type.class, Block.class, MethodHandle.class);

    private ArrayFilterFunction() {
        super(new Signature("filter", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"function(T,boolean)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "return array containing elements that match the given predicate";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(type), this.isDeterministic());
    }

    public static Block filter(Type type, Block block, MethodHandle function) {
        int positionCount = block.getPositionCount();
        BlockBuilder resultBuilder = type.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Object input = TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
            try {
                keep = function.invoke(input);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            type.appendTo(block, position, resultBuilder);
        }
        return resultBuilder.build();
    }
}

