/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.google.common.base.Defaults;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class ArrayDistinctFromOperator {
    private ArrayDistinctFromOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle function, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block left, @IsNull boolean leftNull, @SqlType(value="array(E)") Block right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        if (left.getPositionCount() != right.getPositionCount()) {
            return true;
        }
        for (int i = 0; i < left.getPositionCount(); ++i) {
            Object rightValue;
            boolean rightValueNull;
            boolean leftValueNull;
            Object leftValue = TypeUtils.readNativeValue((Type)type, (Block)left, (int)i);
            boolean bl = leftValueNull = leftValue == null;
            if (leftValueNull) {
                leftValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            boolean bl2 = rightValueNull = (rightValue = TypeUtils.readNativeValue((Type)type, (Block)right, (int)i)) == null;
            if (rightValueNull) {
                rightValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            try {
                if (!function.invoke(leftValue, leftValueNull, rightValue, rightValueNull)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return false;
    }
}

