/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import io.airlift.slice.XxHash64;

public class LocalPartitionGenerator {
    private final HashGenerator hashGenerator;
    private final int hashMask;

    public LocalPartitionGenerator(HashGenerator hashGenerator, int partitionCount) {
        this.hashGenerator = hashGenerator;
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        this.hashMask = partitionCount - 1;
    }

    public int getPartition(int position, Page page) {
        long rawHash = this.getRawHash(position, page);
        return LocalPartitionGenerator.processRawHash(rawHash) & this.hashMask;
    }

    public long getRawHash(int position, Page page) {
        return this.hashGenerator.hashPosition(position, page);
    }

    public int getPartition(long rawHash) {
        return LocalPartitionGenerator.processRawHash(rawHash) & this.hashMask;
    }

    private static int processRawHash(long rawHash) {
        return (int)XxHash64.hash((long)Long.reverse(rawHash));
    }
}

