/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.exchange.BroadcastExchanger;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchangeSink;
import com.facebook.presto.operator.exchange.LocalExchangeSource;
import com.facebook.presto.operator.exchange.PartitioningExchanger;
import com.facebook.presto.operator.exchange.RandomExchanger;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchange {
    private static final DataSize DEFAULT_MAX_BUFFERED_BYTES = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private final List<Type> types;
    private final Supplier<Consumer<Page>> exchangerSupplier;
    private final List<LocalExchangeSource> sources;
    private final LocalExchangeMemoryManager memoryManager;
    @GuardedBy(value="this")
    private boolean allSourcesFinished;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private final Set<LocalExchangeSinkFactory> openSinkFactories = new HashSet<LocalExchangeSinkFactory>();
    @GuardedBy(value="this")
    private final Set<LocalExchangeSink> sinks = new HashSet<LocalExchangeSink>();

    public LocalExchange(PartitioningHandle partitioning, int defaultConcurrency, List<? extends Type> types, List<Integer> partitionChannels, Optional<Integer> partitionHashChannel) {
        this(partitioning, defaultConcurrency, types, partitionChannels, partitionHashChannel, DEFAULT_MAX_BUFFERED_BYTES);
    }

    public LocalExchange(PartitioningHandle partitioning, int defaultConcurrency, List<? extends Type> types, List<Integer> partitionChannels, Optional<Integer> partitionHashChannel, DataSize maxBufferedBytes) {
        int bufferCount;
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            bufferCount = 1;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Gather exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Broadcast exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_RANDOM_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Random exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((!partitionChannels.isEmpty() ? 1 : 0) != 0, (Object)"Partitioned exchange must have partition channels");
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
        ImmutableList.Builder sources = ImmutableList.builder();
        for (int i = 0; i < bufferCount; ++i) {
            sources.add((Object)new LocalExchangeSource(types, source -> this.checkAllSourcesFinished()));
        }
        this.sources = sources.build();
        List buffers = (List)this.sources.stream().map(buffer -> buffer::addPage).collect(ImmutableCollectors.toImmutableList());
        this.memoryManager = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager::updateMemoryUsage);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager::updateMemoryUsage);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_RANDOM_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new RandomExchanger(buffers, this.memoryManager::updateMemoryUsage);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new PartitioningExchanger(buffers, this.memoryManager::updateMemoryUsage, types, partitionChannels, partitionHashChannel);
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getBufferCount() {
        return this.sources.size();
    }

    public long getBufferedBytes() {
        return this.memoryManager.getBufferedBytes();
    }

    public synchronized LocalExchangeSinkFactory createSinkFactory() {
        Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0, (Object)"No more sink factories already set");
        LocalExchangeSinkFactory newFactory = new LocalExchangeSinkFactory(this);
        this.openSinkFactories.add(newFactory);
        return newFactory;
    }

    public LocalExchangeSource getSource(int partitionIndex) {
        return this.sources.get(partitionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSourcesFinished() {
        ImmutableList openSinks;
        LocalExchange.checkNotHoldsLock(this);
        if (!this.sources.stream().allMatch(LocalExchangeSource::isFinished)) {
            return;
        }
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.allSourcesFinished = true;
            openSinks = ImmutableList.copyOf(this.sinks);
            this.sinks.clear();
        }
        openSinks.forEach(LocalExchangeSink::finish);
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalExchangeSink createSink(LocalExchangeSinkFactory factory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            Preconditions.checkState((boolean)this.openSinkFactories.contains(factory), (Object)"Factory is already closed");
            if (this.allSourcesFinished) {
                return LocalExchangeSink.finishedLocalExchangeSink(this.types, this.memoryManager);
            }
            Consumer<Page> exchanger = this.exchangerSupplier.get();
            LocalExchangeSink sink = new LocalExchangeSink(this.types, exchanger, this.memoryManager, this::sinkFinished);
            this.sinks.add(sink);
            return sink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFinished(LocalExchangeSink sink) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.sinks.remove(sink);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreSinkFactories() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.noMoreSinkFactories = true;
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFactoryClosed(LocalExchangeSinkFactory sinkFactory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.openSinkFactories.remove(sinkFactory);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSinksComplete() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            if (!(this.noMoreSinkFactories && this.openSinkFactories.isEmpty() && this.sinks.isEmpty())) {
                return;
            }
        }
        this.sources.forEach(LocalExchangeSource::finish);
        this.memoryManager.setNoBlockOnFull();
    }

    private static void checkNotHoldsLock(Object lock) {
        Preconditions.checkState((!Thread.holdsLock(lock) ? 1 : 0) != 0, (Object)"Can not execute this method while holding a lock");
    }

    @ThreadSafe
    public static class LocalExchangeSinkFactory
    implements Closeable {
        private final LocalExchange exchange;

        private LocalExchangeSinkFactory(LocalExchange exchange) {
            this.exchange = Objects.requireNonNull(exchange, "exchange is null");
        }

        public List<Type> getTypes() {
            return this.exchange.getTypes();
        }

        public LocalExchangeSink createSink() {
            return this.exchange.createSink(this);
        }

        public LocalExchangeSinkFactory duplicate() {
            return this.exchange.createSinkFactory();
        }

        @Override
        public void close() {
            this.exchange.sinkFactoryClosed(this);
        }

        public void noMoreSinkFactories() {
            this.exchange.noMoreSinkFactories();
        }
    }
}

