/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.KeyValuePairs;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.KeyValuePairsState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.type.Type;
import java.util.Objects;

public class KeyValuePairsStateFactory
implements AccumulatorStateFactory<KeyValuePairsState> {
    private final Type keyType;
    private final Type valueType;

    public KeyValuePairsStateFactory(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public KeyValuePairsState createSingleState() {
        return new SingleState(this.keyType, this.valueType);
    }

    public Class<? extends KeyValuePairsState> getSingleStateClass() {
        return SingleState.class;
    }

    public KeyValuePairsState createGroupedState() {
        return new GroupedState(this.keyType, this.valueType);
    }

    public Class<? extends KeyValuePairsState> getGroupedStateClass() {
        return GroupedState.class;
    }

    public static class SingleState
    implements KeyValuePairsState {
        private final Type keyType;
        private final Type valueType;
        private KeyValuePairs pair;

        public SingleState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public KeyValuePairs get() {
            return this.pair;
        }

        @Override
        public void set(KeyValuePairs value) {
            this.pair = value;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        public long getEstimatedSize() {
            if (this.pair == null) {
                return 0L;
            }
            return this.pair.estimatedInMemorySize();
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements KeyValuePairsState {
        private final Type keyType;
        private final Type valueType;
        private final ObjectBigArray<KeyValuePairs> pairs = new ObjectBigArray();
        private long size;

        public GroupedState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public void ensureCapacity(long size) {
            this.pairs.ensureCapacity(size);
        }

        @Override
        public KeyValuePairs get() {
            return (KeyValuePairs)this.pairs.get(this.getGroupId());
        }

        @Override
        public void set(KeyValuePairs value) {
            Objects.requireNonNull(value, "value is null");
            KeyValuePairs previous = this.get();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.pairs.set(this.getGroupId(), (Object)value);
            this.size += value.estimatedInMemorySize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        public long getEstimatedSize() {
            return this.size + this.pairs.sizeOf();
        }
    }
}

