/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.stats.cardinality.HyperLogLog;
import java.util.Objects;

public class HyperLogLogStateFactory
implements AccumulatorStateFactory<HyperLogLogState> {
    public HyperLogLogState createSingleState() {
        return new SingleHyperLogLogState();
    }

    public Class<? extends HyperLogLogState> getSingleStateClass() {
        return SingleHyperLogLogState.class;
    }

    public HyperLogLogState createGroupedState() {
        return new GroupedHyperLogLogState();
    }

    public Class<? extends HyperLogLogState> getGroupedStateClass() {
        return GroupedHyperLogLogState.class;
    }

    public static class SingleHyperLogLogState
    implements HyperLogLogState {
        private HyperLogLog hll;

        @Override
        public HyperLogLog getHyperLogLog() {
            return this.hll;
        }

        @Override
        public void setHyperLogLog(HyperLogLog value) {
            this.hll = value;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            if (this.hll == null) {
                return 0L;
            }
            return this.hll.estimatedInMemorySize();
        }
    }

    public static class GroupedHyperLogLogState
    extends AbstractGroupedAccumulatorState
    implements HyperLogLogState {
        private final ObjectBigArray<HyperLogLog> hlls = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.hlls.ensureCapacity(size);
        }

        @Override
        public HyperLogLog getHyperLogLog() {
            return (HyperLogLog)this.hlls.get(this.getGroupId());
        }

        @Override
        public void setHyperLogLog(HyperLogLog value) {
            Objects.requireNonNull(value, "value is null");
            this.hlls.set(this.getGroupId(), (Object)value);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return this.size + this.hlls.sizeOf();
        }
    }
}

