/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;

@AggregationFunction
@Description(value="Returns the variance of the argument")
public final class VarianceAggregation {
    private VarianceAggregation() {
    }

    @InputFunction
    public static void doubleInput(VarianceState state, @SqlType(value="double") double value) {
        AggregationUtils.updateVarianceState(state, value);
    }

    @InputFunction
    public static void bigintInput(VarianceState state, @SqlType(value="bigint") long value) {
        AggregationUtils.updateVarianceState(state, value);
    }

    @CombineFunction
    public static void combine(VarianceState state, VarianceState otherState) {
        AggregationUtils.mergeVarianceState(state, otherState);
    }

    @AggregationFunction(value="variance", alias={"var_samp"})
    @Description(value="Returns the sample variance of the argument")
    @OutputFunction(value="double")
    public static void variance(VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="var_pop")
    @Description(value="Returns the population variance of the argument")
    @OutputFunction(value="double")
    public static void variancePop(VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count == 0L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)count;
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="stddev", alias={"stddev_samp"})
    @OutputFunction(value="double")
    public static void stddev(VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            result = Math.sqrt(result);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="stddev_pop")
    @OutputFunction(value="double")
    public static void stddevPop(VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count == 0L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)count;
            result = Math.sqrt(result);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

