/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.BlockComparator;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.RowType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class TypedKeyValueHeap {
    private static final int COMPACT_THRESHOLD_BYTES = 32768;
    private static final int COMPACT_THRESHOLD_RATIO = 3;
    private final BlockComparator keyComparator;
    private final Type keyType;
    private final Type valueType;
    private final int capacity;
    private int positionCount;
    private final int[] heapIndex;
    private BlockBuilder keyBlockBuilder;
    private BlockBuilder valueBlockBuilder;

    public TypedKeyValueHeap(BlockComparator keyComparator, Type keyType, Type valueType, int capacity) {
        this.keyComparator = keyComparator;
        this.keyType = keyType;
        this.valueType = valueType;
        this.capacity = capacity;
        this.heapIndex = new int[capacity];
        this.keyBlockBuilder = keyType.createBlockBuilder(new BlockBuilderStatus(), capacity);
        this.valueBlockBuilder = valueType.createBlockBuilder(new BlockBuilderStatus(), capacity);
    }

    public static Type getSerializedType(Type keyType, Type valueType) {
        return new RowType((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)((Object)new ArrayType(keyType)), (Object)((Object)new ArrayType(valueType))), Optional.empty());
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getEstimatedSize() {
        return this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + this.capacity * 4;
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder blockBuilder = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(blockBuilder, (long)this.getCapacity());
        BlockBuilder keyElements = blockBuilder.beginBlockEntry();
        for (int i = 0; i < this.positionCount; ++i) {
            this.keyType.appendTo((Block)this.keyBlockBuilder, this.heapIndex[i], keyElements);
        }
        blockBuilder.closeEntry();
        BlockBuilder valueElements = blockBuilder.beginBlockEntry();
        for (int i = 0; i < this.positionCount; ++i) {
            this.valueType.appendTo((Block)this.valueBlockBuilder, this.heapIndex[i], valueElements);
        }
        blockBuilder.closeEntry();
        out.closeEntry();
    }

    public static TypedKeyValueHeap deserialize(Block block, Type keyType, Type valueType, BlockComparator blockComparator) {
        int capacity = Math.toIntExact(BigintType.BIGINT.getLong(block, 0));
        Block keysBlock = new ArrayType(keyType).getObject(block, 1);
        Block valuesBlock = new ArrayType(valueType).getObject(block, 2);
        TypedKeyValueHeap heap = new TypedKeyValueHeap(blockComparator, keyType, valueType, capacity);
        heap.addAll(keysBlock, valuesBlock);
        return heap;
    }

    public void popAll(BlockBuilder resultBlockBuilder) {
        while (this.positionCount > 0) {
            this.pop(resultBlockBuilder);
        }
    }

    public void pop(BlockBuilder resultBlockBuilder) {
        this.valueType.appendTo((Block)this.valueBlockBuilder, this.heapIndex[0], resultBlockBuilder);
        this.remove();
    }

    private void remove() {
        --this.positionCount;
        this.heapIndex[0] = this.heapIndex[this.positionCount];
        this.siftDown();
    }

    public void add(Block keyBlock, Block valueBlock, int position) {
        Preconditions.checkArgument((!keyBlock.isNull(position) ? 1 : 0) != 0);
        if (this.positionCount == this.capacity) {
            if (this.keyComparator.compareTo((Block)this.keyBlockBuilder, this.heapIndex[0], keyBlock, position) >= 0) {
                return;
            }
            this.heapIndex[0] = this.keyBlockBuilder.getPositionCount();
            this.keyType.appendTo(keyBlock, position, this.keyBlockBuilder);
            this.valueType.appendTo(valueBlock, position, this.valueBlockBuilder);
            this.siftDown();
        } else {
            this.heapIndex[this.positionCount] = this.keyBlockBuilder.getPositionCount();
            ++this.positionCount;
            this.keyType.appendTo(keyBlock, position, this.keyBlockBuilder);
            this.valueType.appendTo(valueBlock, position, this.valueBlockBuilder);
            this.siftUp();
        }
        this.compactIfNecessary();
    }

    public void addAll(TypedKeyValueHeap otherHeap) {
        this.addAll((Block)otherHeap.keyBlockBuilder, (Block)otherHeap.valueBlockBuilder);
    }

    public void addAll(Block keysBlock, Block valuesBlock) {
        for (int i = 0; i < keysBlock.getPositionCount(); ++i) {
            this.add(keysBlock, valuesBlock, i);
        }
    }

    private void siftDown() {
        int leftPosition;
        int position = 0;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.keyComparator.compareTo((Block)this.keyBlockBuilder, this.heapIndex[leftPosition], (Block)this.keyBlockBuilder, this.heapIndex[rightPosition]) >= 0 ? rightPosition : leftPosition;
            }
            if (this.keyComparator.compareTo((Block)this.keyBlockBuilder, this.heapIndex[smallerChildPosition], (Block)this.keyBlockBuilder, this.heapIndex[position]) >= 0) break;
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[smallerChildPosition];
            this.heapIndex[smallerChildPosition] = swapTemp;
            position = smallerChildPosition;
        }
    }

    private void siftUp() {
        int parentPosition;
        int position = this.positionCount - 1;
        while (position != 0 && this.keyComparator.compareTo((Block)this.keyBlockBuilder, this.heapIndex[position], (Block)this.keyBlockBuilder, this.heapIndex[parentPosition = (position - 1) / 2]) < 0) {
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[parentPosition];
            this.heapIndex[parentPosition] = swapTemp;
            position = parentPosition;
        }
    }

    private void compactIfNecessary() {
        if (this.keyBlockBuilder.getSizeInBytes() < 32768 || this.keyBlockBuilder.getPositionCount() / this.positionCount < 3) {
            return;
        }
        BlockBuilder newHeapKeyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), this.keyBlockBuilder.getPositionCount());
        BlockBuilder newHeapValueBlockBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), this.valueBlockBuilder.getPositionCount());
        for (int i = 0; i < this.positionCount; ++i) {
            this.keyType.appendTo((Block)this.keyBlockBuilder, this.heapIndex[i], newHeapKeyBlockBuilder);
            this.valueType.appendTo((Block)this.valueBlockBuilder, this.heapIndex[i], newHeapValueBlockBuilder);
            this.heapIndex[i] = i;
        }
        this.keyBlockBuilder = newHeapKeyBlockBuilder;
        this.valueBlockBuilder = newHeapValueBlockBuilder;
    }
}

