/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.DoubleCovarianceAggregation;
import com.facebook.presto.operator.aggregation.state.CovarianceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.RealType;

@AggregationFunction
public class RealCovarianceAggregation {
    private RealCovarianceAggregation() {
    }

    @InputFunction
    public static void input(CovarianceState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleCovarianceAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(CovarianceState state, CovarianceState otherState) {
        DoubleCovarianceAggregation.combine(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="real")
    public static void covarSamp(CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovarianceSample(state);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="real")
    public static void covarPop(CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovariancePopulation(state);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        }
    }
}

