/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactoryBinder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class InternalAggregationFunction {
    private final String name;
    private final List<Type> parameterTypes;
    private final Type intermediateType;
    private final Type finalType;
    private final boolean decomposable;
    private final AccumulatorFactoryBinder factory;

    public InternalAggregationFunction(String name, List<Type> parameterTypes, Type intermediateType, Type finalType, boolean decomposable, AccumulatorFactoryBinder factory) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.intermediateType = Objects.requireNonNull(intermediateType, "intermediateType is null");
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.decomposable = decomposable;
        this.factory = Objects.requireNonNull(factory, "factory is null");
    }

    public String name() {
        return this.name;
    }

    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getFinalType() {
        return this.finalType;
    }

    public Type getIntermediateType() {
        return this.intermediateType;
    }

    public boolean isDecomposable() {
        return this.decomposable;
    }

    public AccumulatorFactory bind(List<Integer> inputChannels, Optional<Integer> maskChannel) {
        return this.factory.bind(inputChannels, maskChannel);
    }
}

