/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericAccumulatorFactoryBinder
implements AccumulatorFactoryBinder {
    private final AccumulatorStateSerializer<?> stateSerializer;
    private final AccumulatorStateFactory<?> stateFactory;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;

    public GenericAccumulatorFactoryBinder(AccumulatorStateSerializer<?> stateSerializer, AccumulatorStateFactory<?> stateFactory, Class<? extends Accumulator> accumulatorClass, Class<? extends GroupedAccumulator> groupedAccumulatorClass) {
        this.stateSerializer = Objects.requireNonNull(stateSerializer, "stateSerializer is null");
        this.stateFactory = Objects.requireNonNull(stateFactory, "stateFactory is null");
        try {
            this.accumulatorConstructor = accumulatorClass.getConstructor(AccumulatorStateSerializer.class, AccumulatorStateFactory.class, List.class, Optional.class);
            this.groupedAccumulatorConstructor = groupedAccumulatorClass.getConstructor(AccumulatorStateSerializer.class, AccumulatorStateFactory.class, List.class, Optional.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public AccumulatorFactory bind(List<Integer> argumentChannels, Optional<Integer> maskChannel) {
        return new GenericAccumulatorFactory(this.stateSerializer, this.stateFactory, this.accumulatorConstructor, this.groupedAccumulatorConstructor, argumentChannels, maskChannel);
    }
}

