/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

@AggregationFunction(value="sum")
public final class DoubleSumAggregation {
    private DoubleSumAggregation() {
    }

    @InputFunction
    public static void sum(NullableDoubleState state, @SqlType(value="double") double value) {
        state.setNull(false);
        state.setDouble(state.getDouble() + value);
    }

    @CombineFunction
    public static void combine(NullableDoubleState state, NullableDoubleState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="double")
    public static void output(NullableDoubleState state, BlockBuilder out) {
        NullableDoubleState.write((Type)DoubleType.DOUBLE, state, out);
    }
}

