/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.state.RegressionState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;

@AggregationFunction
public class DoubleRegressionAggregation {
    private DoubleRegressionAggregation() {
    }

    @InputFunction
    public static void input(RegressionState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateRegressionState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(RegressionState state, RegressionState otherState) {
        AggregationUtils.mergeRegressionState(state, otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="double")
    public static void regrSlope(RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSlope(state);
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="double")
    public static void regrIntercept(RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionIntercept(state);
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }
}

