/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.TriStateBooleanState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;

@AggregationFunction(value="bool_or")
public final class BooleanOrAggregation {
    private BooleanOrAggregation() {
    }

    @InputFunction
    public static void booleanOr(TriStateBooleanState state, @SqlType(value="boolean") boolean value) {
        if (value) {
            state.setByte((byte)1);
        } else if (state.getByte() == 0) {
            state.setByte((byte)-1);
        }
    }

    @CombineFunction
    public static void combine(TriStateBooleanState state, TriStateBooleanState otherState) {
        if (state.getByte() == 0) {
            state.setByte(otherState.getByte());
            return;
        }
        if (otherState.getByte() == 1) {
            state.setByte(otherState.getByte());
        }
    }

    @OutputFunction(value="boolean")
    public static void output(TriStateBooleanState state, BlockBuilder out) {
        TriStateBooleanState.write((Type)BooleanType.BOOLEAN, state, out);
    }
}

