/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PartitionedLookupSource
implements LookupSource {
    private final LookupSource[] lookupSources;
    private final LocalPartitionGenerator partitionGenerator;
    private final int partitionMask;
    private final int shiftSize;
    @Nullable
    private final OuterPositionTracker outerPositionTracker;

    public static Supplier<LookupSource> createPartitionedLookupSourceSupplier(List<Supplier<LookupSource>> partitions, List<Type> hashChannelTypes, boolean outer) {
        Optional outerPositionTrackerFactory = outer ? Optional.of(new OuterPositionTracker.Factory((List)partitions.stream().map(partition -> ((LookupSource)partition.get()).getJoinPositionCount()).collect(ImmutableCollectors.toImmutableList()))) : Optional.empty();
        return () -> new PartitionedLookupSource((List)partitions.stream().map(Supplier::get).collect(ImmutableCollectors.toImmutableList()), hashChannelTypes, outerPositionTrackerFactory.map(OuterPositionTracker.Factory::create));
    }

    private PartitionedLookupSource(List<? extends LookupSource> lookupSources, List<Type> hashChannelTypes, Optional<OuterPositionTracker> outerPositionTracker) {
        this.lookupSources = lookupSources.toArray(new LookupSource[lookupSources.size()]);
        int[] hashChannels = new int[hashChannelTypes.size()];
        for (int i = 0; i < hashChannels.length; ++i) {
            hashChannels[i] = i;
        }
        this.partitionGenerator = new LocalPartitionGenerator(new InterpretedHashGenerator(hashChannelTypes, hashChannels), lookupSources.size());
        this.partitionMask = lookupSources.size() - 1;
        this.shiftSize = Integer.numberOfTrailingZeros(lookupSources.size()) + 1;
        this.outerPositionTracker = outerPositionTracker.orElse(null);
    }

    @Override
    public int getChannelCount() {
        return this.lookupSources[0].getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        throw new UnsupportedOperationException("Parallel hash can not be used in a RIGHT or FULL outer join");
    }

    @Override
    public long getInMemorySizeInBytes() {
        return Arrays.stream(this.lookupSources).mapToLong(LookupSource::getInMemorySizeInBytes).sum();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        return this.getJoinPosition(position, hashChannelsPage, allChannelsPage, this.partitionGenerator.getRawHash(position, hashChannelsPage));
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int partition = this.partitionGenerator.getPartition(rawHash);
        LookupSource lookupSource = this.lookupSources[partition];
        long joinPosition = lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage, rawHash);
        if (joinPosition < 0L) {
            return joinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, Math.toIntExact(joinPosition));
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        long joinPosition;
        int partition = this.decodePartition(currentJoinPosition);
        LookupSource lookupSource = this.lookupSources[partition];
        long nextJoinPosition = lookupSource.getNextJoinPosition(joinPosition = (long)this.decodeJoinPosition(currentJoinPosition), probePosition, allProbeChannelsPage);
        if (nextJoinPosition < 0L) {
            return nextJoinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, Math.toIntExact(nextJoinPosition));
    }

    @Override
    public void appendTo(long partitionedJoinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        int partition = this.decodePartition(partitionedJoinPosition);
        int joinPosition = this.decodeJoinPosition(partitionedJoinPosition);
        this.lookupSources[partition].appendTo(joinPosition, pageBuilder, outputChannelOffset);
        if (this.outerPositionTracker != null) {
            this.outerPositionTracker.positionVisited(partition, joinPosition);
        }
    }

    @Override
    public LookupSource.OuterPositionIterator getOuterPositionIterator() {
        Preconditions.checkState((this.outerPositionTracker != null ? 1 : 0) != 0, (Object)"This is not an outer lookup source");
        return new PartitionedLookupOuterPositionIterator(this.lookupSources, this.outerPositionTracker.getVisitedPositions());
    }

    @Override
    public void close() {
        if (this.outerPositionTracker != null) {
            this.outerPositionTracker.commit();
        }
    }

    private int decodePartition(long partitionedJoinPosition) {
        return (int)(partitionedJoinPosition & (long)this.partitionMask);
    }

    private int decodeJoinPosition(long partitionedJoinPosition) {
        return Math.toIntExact(partitionedJoinPosition >>> this.shiftSize);
    }

    private long encodePartitionedJoinPosition(int partition, int joinPosition) {
        return (long)joinPosition << this.shiftSize | (long)partition;
    }

    private static class OuterPositionTracker {
        private final boolean[][] visitedPositions;
        private final AtomicLong referenceCount;
        private boolean written;

        private OuterPositionTracker(boolean[][] visitedPositions, AtomicLong referenceCount) {
            this.visitedPositions = visitedPositions;
            this.referenceCount = referenceCount;
        }

        public void positionVisited(int partition, int position) {
            if (!this.written) {
                this.written = true;
                this.incrementReferenceCount();
            }
            this.visitedPositions[partition][position] = true;
        }

        public void commit() {
            if (this.written) {
                this.referenceCount.decrementAndGet();
            }
        }

        public boolean[][] getVisitedPositions() {
            Verify.verify((this.referenceCount.get() == 0L ? 1 : 0) != 0);
            return this.visitedPositions;
        }

        private void incrementReferenceCount() {
            this.referenceCount.incrementAndGet();
        }

        public static class Factory {
            private final boolean[][] visitedPositions;
            private final AtomicLong referenceCount = new AtomicLong();

            public Factory(List<Integer> positionCounts) {
                this.visitedPositions = new boolean[positionCounts.size()][];
                for (int partition = 0; partition < this.visitedPositions.length; ++partition) {
                    this.visitedPositions[partition] = new boolean[positionCounts.get(partition).intValue()];
                }
            }

            public OuterPositionTracker create() {
                return new OuterPositionTracker(this.visitedPositions, this.referenceCount);
            }
        }
    }

    private static class PartitionedLookupOuterPositionIterator
    implements LookupSource.OuterPositionIterator {
        private final LookupSource[] lookupSources;
        private final boolean[][] visitedPositions;
        @GuardedBy(value="this")
        private int currentSource;
        @GuardedBy(value="this")
        private int currentPosition;

        public PartitionedLookupOuterPositionIterator(LookupSource[] lookupSources, boolean[][] visitedPositions) {
            this.lookupSources = lookupSources;
            this.visitedPositions = visitedPositions;
        }

        @Override
        public synchronized boolean appendToNext(PageBuilder pageBuilder, int outputChannelOffset) {
            while (this.currentSource < this.lookupSources.length) {
                while (this.currentPosition < this.visitedPositions[this.currentSource].length) {
                    if (!this.visitedPositions[this.currentSource][this.currentPosition]) {
                        this.lookupSources[this.currentSource].appendTo(this.currentPosition, pageBuilder, outputChannelOffset);
                        ++this.currentPosition;
                        return true;
                    }
                    ++this.currentPosition;
                }
                this.currentPosition = 0;
                ++this.currentSource;
            }
            return false;
        }
    }
}

