/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.Mergeable;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OperatorStats {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final long totalDrivers;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final Duration addInputUser;
    private final DataSize inputDataSize;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final Duration getOutputUser;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final Duration finishUser;
    private final DataSize memoryReservation;
    private final DataSize systemMemoryReservation;
    private final Optional<BlockedReason> blockedReason;
    private final OperatorInfo info;

    @JsonCreator
    public OperatorStats(@JsonProperty(value="operatorId") int operatorId, @JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="operatorType") String operatorType, @JsonProperty(value="totalDrivers") long totalDrivers, @JsonProperty(value="addInputCalls") long addInputCalls, @JsonProperty(value="addInputWall") Duration addInputWall, @JsonProperty(value="addInputCpu") Duration addInputCpu, @JsonProperty(value="addInputUser") Duration addInputUser, @JsonProperty(value="inputDataSize") DataSize inputDataSize, @JsonProperty(value="inputPositions") long inputPositions, @JsonProperty(value="sumSquaredInputPositions") double sumSquaredInputPositions, @JsonProperty(value="getOutputCalls") long getOutputCalls, @JsonProperty(value="getOutputWall") Duration getOutputWall, @JsonProperty(value="getOutputCpu") Duration getOutputCpu, @JsonProperty(value="getOutputUser") Duration getOutputUser, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="blockedWall") Duration blockedWall, @JsonProperty(value="finishCalls") long finishCalls, @JsonProperty(value="finishWall") Duration finishWall, @JsonProperty(value="finishCpu") Duration finishCpu, @JsonProperty(value="finishUser") Duration finishUser, @JsonProperty(value="memoryReservation") DataSize memoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="blockedReason") Optional<BlockedReason> blockedReason, @JsonProperty(value="info") OperatorInfo info) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        this.addInputUser = Objects.requireNonNull(addInputUser, "addInputUser is null");
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        this.getOutputUser = Objects.requireNonNull(getOutputUser, "getOutputUser is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        this.finishUser = Objects.requireNonNull(finishUser, "finishUser is null");
        this.memoryReservation = Objects.requireNonNull(memoryReservation, "memoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.blockedReason = blockedReason;
        this.info = info;
    }

    @JsonProperty
    public int getOperatorId() {
        return this.operatorId;
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    public String getOperatorType() {
        return this.operatorType;
    }

    @JsonProperty
    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    @JsonProperty
    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    @JsonProperty
    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    @JsonProperty
    public Duration getAddInputUser() {
        return this.addInputUser;
    }

    @JsonProperty
    public DataSize getInputDataSize() {
        return this.inputDataSize;
    }

    @JsonProperty
    public long getInputPositions() {
        return this.inputPositions;
    }

    @JsonProperty
    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    @JsonProperty
    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    @JsonProperty
    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    @JsonProperty
    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    @JsonProperty
    public Duration getGetOutputUser() {
        return this.getOutputUser;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    @JsonProperty
    public long getFinishCalls() {
        return this.finishCalls;
    }

    @JsonProperty
    public Duration getFinishWall() {
        return this.finishWall;
    }

    @JsonProperty
    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    @JsonProperty
    public Duration getFinishUser() {
        return this.finishUser;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    @JsonProperty
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    @Nullable
    @JsonProperty
    public OperatorInfo getInfo() {
        return this.info;
    }

    public OperatorStats add(OperatorStats ... operators) {
        return this.add((Iterable<OperatorStats>)ImmutableList.copyOf((Object[])operators));
    }

    public OperatorStats add(Iterable<OperatorStats> operators) {
        long totalDrivers = this.totalDrivers;
        long addInputCalls = this.addInputCalls;
        long addInputWall = this.addInputWall.roundTo(TimeUnit.NANOSECONDS);
        long addInputCpu = this.addInputCpu.roundTo(TimeUnit.NANOSECONDS);
        long addInputUser = this.addInputUser.roundTo(TimeUnit.NANOSECONDS);
        long inputDataSize = this.inputDataSize.toBytes();
        long inputPositions = this.inputPositions;
        double sumSquaredInputPositions = this.sumSquaredInputPositions;
        long getOutputCalls = this.getOutputCalls;
        long getOutputWall = this.getOutputWall.roundTo(TimeUnit.NANOSECONDS);
        long getOutputCpu = this.getOutputCpu.roundTo(TimeUnit.NANOSECONDS);
        long getOutputUser = this.getOutputUser.roundTo(TimeUnit.NANOSECONDS);
        long outputDataSize = this.outputDataSize.toBytes();
        long outputPositions = this.outputPositions;
        long blockedWall = this.blockedWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCalls = this.finishCalls;
        long finishWall = this.finishWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCpu = this.finishCpu.roundTo(TimeUnit.NANOSECONDS);
        long finishUser = this.finishUser.roundTo(TimeUnit.NANOSECONDS);
        long memoryReservation = this.memoryReservation.toBytes();
        long systemMemoryReservation = this.systemMemoryReservation.toBytes();
        Optional<BlockedReason> blockedReason = this.blockedReason;
        Mergeable<OperatorInfo> base = OperatorStats.getMergeableInfoOrNull(this.info);
        for (OperatorStats operator : operators) {
            Preconditions.checkArgument((operator.getOperatorId() == this.operatorId ? 1 : 0) != 0, (String)"Expected operatorId to be %s but was %s", (Object[])new Object[]{this.operatorId, operator.getOperatorId()});
            totalDrivers += operator.totalDrivers;
            addInputCalls += operator.getAddInputCalls();
            addInputWall += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            addInputCpu += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            addInputUser += operator.getAddInputUser().roundTo(TimeUnit.NANOSECONDS);
            inputDataSize += operator.getInputDataSize().toBytes();
            inputPositions += operator.getInputPositions();
            sumSquaredInputPositions += operator.getSumSquaredInputPositions();
            getOutputCalls += operator.getGetOutputCalls();
            getOutputWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            getOutputCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            getOutputUser += operator.getGetOutputUser().roundTo(TimeUnit.NANOSECONDS);
            outputDataSize += operator.getOutputDataSize().toBytes();
            outputPositions += operator.getOutputPositions();
            finishCalls += operator.getFinishCalls();
            finishWall += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            finishCpu += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            finishUser += operator.getFinishUser().roundTo(TimeUnit.NANOSECONDS);
            blockedWall += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
            memoryReservation += operator.getMemoryReservation().toBytes();
            systemMemoryReservation += operator.getSystemMemoryReservation().toBytes();
            if (operator.getBlockedReason().isPresent()) {
                blockedReason = operator.getBlockedReason();
            }
            OperatorInfo info = operator.getInfo();
            if (base == null || info == null || base.getClass() != info.getClass()) continue;
            base = OperatorStats.mergeInfo(base, info);
        }
        return new OperatorStats(this.operatorId, this.planNodeId, this.operatorType, totalDrivers, addInputCalls, new Duration((double)addInputWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)addInputCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)addInputUser, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)inputDataSize), inputPositions, sumSquaredInputPositions, getOutputCalls, new Duration((double)getOutputWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)getOutputCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)getOutputUser, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)outputDataSize), outputPositions, new Duration((double)blockedWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), finishCalls, new Duration((double)finishWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)finishCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)finishUser, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)memoryReservation), DataSize.succinctBytes((long)systemMemoryReservation), blockedReason, (OperatorInfo)((Object)base));
    }

    private static Mergeable<OperatorInfo> getMergeableInfoOrNull(OperatorInfo info) {
        Mergeable base = null;
        if (info instanceof Mergeable) {
            base = (Mergeable)((Object)info);
        }
        return base;
    }

    private static <T> Mergeable<T> mergeInfo(Mergeable<T> base, T other) {
        return (Mergeable)base.mergeWith(other);
    }

    public OperatorStats summarize() {
        return new OperatorStats(this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.addInputCalls, this.addInputWall, this.addInputCpu, this.addInputUser, this.inputDataSize, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.getOutputUser, this.outputDataSize, this.outputPositions, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.finishUser, this.memoryReservation, this.systemMemoryReservation, this.blockedReason, this.info != null && this.info.isFinal() ? this.info : null);
    }
}

