/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.memory.AbstractAggregatedMemoryContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class OperatorContext {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final DriverContext driverContext;
    private final Executor executor;
    private final AtomicLong intervalWallStart = new AtomicLong();
    private final AtomicLong intervalCpuStart = new AtomicLong();
    private final AtomicLong intervalUserStart = new AtomicLong();
    private final AtomicLong addInputCalls = new AtomicLong();
    private final AtomicLong addInputWallNanos = new AtomicLong();
    private final AtomicLong addInputCpuNanos = new AtomicLong();
    private final AtomicLong addInputUserNanos = new AtomicLong();
    private final CounterStat inputDataSize = new CounterStat();
    private final CounterStat inputPositions = new CounterStat();
    private final AtomicLong getOutputCalls = new AtomicLong();
    private final AtomicLong getOutputWallNanos = new AtomicLong();
    private final AtomicLong getOutputCpuNanos = new AtomicLong();
    private final AtomicLong getOutputUserNanos = new AtomicLong();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicReference<SettableFuture<?>> memoryFuture = new AtomicReference();
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicLong finishCalls = new AtomicLong();
    private final AtomicLong finishWallNanos = new AtomicLong();
    private final AtomicLong finishCpuNanos = new AtomicLong();
    private final AtomicLong finishUserNanos = new AtomicLong();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final OperatorSystemMemoryContext systemMemoryContext;
    private final AtomicReference<Supplier<OperatorInfo>> infoSupplier = new AtomicReference();
    private final boolean collectTimings;

    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, DriverContext driverContext, Executor executor) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
        this.systemMemoryContext = new OperatorSystemMemoryContext(this.driverContext);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        SettableFuture future = SettableFuture.create();
        future.set(null);
        this.memoryFuture.set(future);
        this.collectTimings = driverContext.isVerboseStats() && driverContext.isCpuTimerEnabled();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Session getSession() {
        return this.driverContext.getSession();
    }

    public boolean isDone() {
        return this.driverContext.isDone();
    }

    public void startIntervalTimer() {
        this.intervalWallStart.set(System.nanoTime());
        this.intervalCpuStart.set(this.currentThreadCpuTime());
        this.intervalUserStart.set(this.currentThreadUserTime());
    }

    public void recordAddInput(Page page) {
        this.addInputCalls.incrementAndGet();
        this.recordInputWallNanos(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.addInputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.addInputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.inputDataSize.update(page.getSizeInBytes());
            this.inputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedInput(long sizeInBytes, long positions) {
        this.recordGeneratedInput(sizeInBytes, positions, 0L);
    }

    public void recordGeneratedInput(long sizeInBytes, long positions, long readNanos) {
        this.inputDataSize.update(sizeInBytes);
        this.inputPositions.update(positions);
        this.recordInputWallNanos(readNanos);
    }

    public long recordInputWallNanos(long readNanos) {
        return this.addInputWallNanos.getAndAdd(readNanos);
    }

    public void recordGetOutput(Page page) {
        this.getOutputCalls.incrementAndGet();
        this.getOutputWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.getOutputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.getOutputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.outputDataSize.update(page.getSizeInBytes());
            this.outputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedOutput(long sizeInBytes, long positions) {
        this.outputDataSize.update(sizeInBytes);
        this.outputPositions.update(positions);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.executor);
    }

    public void recordFinish() {
        this.finishCalls.incrementAndGet();
        this.finishWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.finishCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.finishUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
    }

    public ListenableFuture<?> isWaitingForMemory() {
        return (ListenableFuture)this.memoryFuture.get();
    }

    public void reserveMemory(long bytes) {
        ListenableFuture<?> future = this.driverContext.reserveMemory(bytes);
        if (!future.isDone()) {
            SettableFuture<?> currentMemoryFuture = this.memoryFuture.get();
            while (currentMemoryFuture.isDone()) {
                SettableFuture<?> settableFuture = SettableFuture.create();
                if (this.memoryFuture.compareAndSet(currentMemoryFuture, settableFuture)) {
                    currentMemoryFuture = settableFuture;
                    continue;
                }
                currentMemoryFuture = this.memoryFuture.get();
            }
            final SettableFuture<?> finalMemoryFuture = currentMemoryFuture;
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    finalMemoryFuture.set(null);
                }

                public void onFailure(Throwable t) {
                    finalMemoryFuture.set(null);
                }
            });
        }
        this.memoryReservation.addAndGet(bytes);
    }

    public void freeMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.memoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.driverContext.freeMemory(bytes);
        this.memoryReservation.getAndAdd(-bytes);
    }

    public AbstractAggregatedMemoryContext getSystemMemoryContext() {
        return this.systemMemoryContext;
    }

    public void closeSystemMemoryContext() {
        this.systemMemoryContext.close();
    }

    public void moreMemoryAvailable() {
        this.memoryFuture.get().set(null);
    }

    public void transferMemoryToTaskContext(long taskBytes) {
        long bytes = this.memoryReservation.getAndSet(0L);
        this.driverContext.transferMemoryToTaskContext(bytes);
        TaskContext taskContext = this.driverContext.getPipelineContext().getTaskContext();
        if (taskBytes > bytes) {
            try {
                taskContext.reserveMemory(taskBytes - bytes);
            }
            catch (ExceededMemoryLimitException e) {
                taskContext.freeMemory(bytes);
                throw e;
            }
        } else {
            taskContext.freeMemory(bytes - taskBytes);
        }
    }

    public void setMemoryReservation(long newMemoryReservation) {
        Preconditions.checkArgument((newMemoryReservation >= 0L ? 1 : 0) != 0, (Object)"newMemoryReservation is negative");
        long delta = newMemoryReservation - this.memoryReservation.get();
        if (delta > 0L) {
            this.reserveMemory(delta);
        } else {
            this.freeMemory(-delta);
        }
    }

    public boolean trySetMemoryReservation(long newMemoryReservation) {
        Preconditions.checkArgument((newMemoryReservation >= 0L ? 1 : 0) != 0, (Object)"newMemoryReservation is negative");
        long delta = newMemoryReservation - this.memoryReservation.get();
        if (delta > 0L) {
            if (!this.driverContext.tryReserveMemory(delta)) {
                return false;
            }
            this.memoryReservation.addAndGet(delta);
        } else {
            this.freeMemory(-delta);
        }
        return true;
    }

    public void setInfoSupplier(Supplier<OperatorInfo> infoSupplier) {
        Objects.requireNonNull(infoSupplier, "infoProvider is null");
        this.infoSupplier.set(infoSupplier);
    }

    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public OperatorStats getOperatorStats() {
        Supplier<OperatorInfo> infoSupplier = this.infoSupplier.get();
        OperatorInfo info = Optional.ofNullable(infoSupplier).map(Supplier::get).orElse(null);
        long inputPositionsCount = this.inputPositions.getTotalCount();
        return new OperatorStats(this.operatorId, this.planNodeId, this.operatorType, 1L, this.addInputCalls.get(), new Duration((double)this.addInputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.inputDataSize.getTotalCount()), inputPositionsCount, (double)inputPositionsCount * (double)inputPositionsCount, this.getOutputCalls.get(), new Duration((double)this.getOutputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.outputDataSize.getTotalCount()), this.outputPositions.getTotalCount(), new Duration((double)this.blockedWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), this.finishCalls.get(), new Duration((double)this.finishWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.memoryReservation.get()), DataSize.succinctBytes((long)this.systemMemoryContext.getReservedBytes()), this.memoryFuture.get().isDone() ? Optional.empty() : Optional.of(BlockedReason.WAITING_FOR_MEMORY), info);
    }

    private long currentThreadUserTime() {
        if (!this.collectTimings) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadUserTime();
    }

    private long currentThreadCpuTime() {
        if (!this.collectTimings) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long nanosBetween(long start, long end) {
        return Math.abs(end - start);
    }

    private static class OperatorSystemMemoryContext
    extends AbstractAggregatedMemoryContext {
        private final DriverContext driverContext;
        private boolean closed;
        private long reservedBytes;

        public OperatorSystemMemoryContext(DriverContext driverContext) {
            this.driverContext = driverContext;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.driverContext.freeSystemMemory(this.reservedBytes);
            this.reservedBytes = 0L;
        }

        @Override
        protected void updateBytes(long bytes) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            if (bytes > 0L) {
                this.driverContext.reserveSystemMemory(bytes);
            } else {
                Preconditions.checkArgument((this.reservedBytes + bytes >= 0L ? 1 : 0) != 0, (String)"tried to free %s bytes of memory from %s bytes reserved", (Object[])new Object[]{-bytes, this.reservedBytes});
                this.driverContext.freeSystemMemory(-bytes);
            }
            this.reservedBytes += bytes;
        }

        public long getReservedBytes() {
            return this.reservedBytes;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.reservedBytes).add("closed", this.closed).toString();
        }
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        @Override
        public synchronized void run() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            OperatorContext.this.blockedMonitor.compareAndSet(this, null);
            OperatorContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
        }

        public long getBlockedTime() {
            return OperatorContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

