/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> probeOutputTypes;
    private final List<Type> buildTypes;
    private final List<Type> buildOutputTypes;
    private final LookupJoinOperators.JoinType joinType;
    private final LookupSourceFactory lookupSourceFactory;
    private final JoinProbeFactory joinProbeFactory;
    private final Optional<OperatorFactory> outerOperatorFactory;
    private final ReferenceCount referenceCount;
    private boolean closed;

    /*
     * Enabled aggressive block sorting
     */
    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, LookupSourceFactory lookupSourceFactory, List<Type> probeTypes, List<Type> probeOutputTypes, LookupJoinOperators.JoinType joinType, JoinProbeFactory joinProbeFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.lookupSourceFactory = Objects.requireNonNull(lookupSourceFactory, "lookupSourceFactory is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.probeOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null"));
        this.buildTypes = ImmutableList.copyOf(lookupSourceFactory.getTypes());
        this.buildOutputTypes = ImmutableList.copyOf(lookupSourceFactory.getOutputTypes());
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.referenceCount = new ReferenceCount();
        if (joinType != LookupJoinOperators.JoinType.INNER && joinType != LookupJoinOperators.JoinType.PROBE_OUTER) {
            SettableFuture outerPositionsFuture = SettableFuture.create();
            this.referenceCount.getFreeFuture().addListener(() -> Futures.addCallback(lookupSourceFactory.createLookupSource(), new OnSuccessFutureCallback<LookupSource>(lookupSource -> outerPositionsFuture.set((Object)lookupSource.getOuterPositionIterator()))), MoreExecutors.directExecutor());
            Runnable onOperatorClose = () -> lookupSourceFactory.createLookupSource().addListener(lookupSourceFactory::destroy, MoreExecutors.directExecutor());
            this.outerOperatorFactory = Optional.of(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, (ListenableFuture<LookupSource.OuterPositionIterator>)outerPositionsFuture, probeOutputTypes, this.buildOutputTypes, onOperatorClose));
            return;
        }
        this.referenceCount.getFreeFuture().addListener(lookupSourceFactory::destroy, MoreExecutors.directExecutor());
        this.outerOperatorFactory = Optional.empty();
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.probeOutputTypes = other.probeOutputTypes;
        this.buildTypes = other.buildTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.lookupSourceFactory = other.lookupSourceFactory;
        this.joinProbeFactory = other.joinProbeFactory;
        this.referenceCount = other.referenceCount;
        this.outerOperatorFactory = other.outerOperatorFactory;
        this.referenceCount.retain();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.builder().addAll(this.probeOutputTypes).addAll(this.buildOutputTypes).build();
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LookupJoinOperator.class.getSimpleName());
        this.lookupSourceFactory.setTaskContext(driverContext.getPipelineContext().getTaskContext());
        this.referenceCount.retain();
        return new LookupJoinOperator(operatorContext, this.getTypes(), this.joinType, this.lookupSourceFactory.createLookupSource(), this.joinProbeFactory, this.referenceCount::release);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.referenceCount.release();
    }

    @Override
    public OperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }

    @Override
    public Optional<OperatorFactory> createOuterOperatorFactory() {
        return this.outerOperatorFactory;
    }

    public static class OnSuccessFutureCallback<T>
    implements FutureCallback<T> {
        private final Consumer<T> onSuccess;

        public OnSuccessFutureCallback(Consumer<T> onSuccess) {
            this.onSuccess = onSuccess;
        }

        public void onSuccess(T result) {
            this.onSuccess.accept(result);
        }

        public void onFailure(Throwable t) {
        }
    }
}

