/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.util.HashCollisionsEstimator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.List;

public class BigintGroupByHash
implements GroupByHash {
    private static final float FILL_RATIO = 0.75f;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final List<Type> TYPES_WITH_RAW_HASH = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private final int hashChannel;
    private final boolean outputRawHash;
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private LongBigArray values;
    private IntBigArray groupIds;
    private int nullGroupId = -1;
    private final LongBigArray valuesByGroupId;
    private int nextGroupId;
    private long hashCollisions;
    private double expectedHashCollisions;

    public BigintGroupByHash(int hashChannel, boolean outputRawHash, int expectedSize) {
        Preconditions.checkArgument((hashChannel >= 0 ? 1 : 0) != 0, (Object)"hashChannel must be at least zero");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.hashChannel = hashChannel;
        this.outputRawHash = outputRawHash;
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = BigintGroupByHash.calculateMaxFill(this.hashCapacity);
        this.mask = this.hashCapacity - 1;
        this.values = new LongBigArray();
        this.values.ensureCapacity((long)this.hashCapacity);
        this.groupIds = new IntBigArray(-1);
        this.groupIds.ensureCapacity((long)this.hashCapacity);
        this.valuesByGroupId = new LongBigArray();
        this.valuesByGroupId.ensureCapacity((long)this.hashCapacity);
    }

    @Override
    public long getEstimatedSize() {
        return this.groupIds.sizeOf() + this.values.sizeOf() + this.valuesByGroupId.sizeOf();
    }

    @Override
    public long getHashCollisions() {
        return this.hashCollisions;
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.expectedHashCollisions + HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
    }

    @Override
    public List<Type> getTypes() {
        return this.outputRawHash ? TYPES_WITH_RAW_HASH : TYPES;
    }

    @Override
    public int getGroupCount() {
        return this.nextGroupId;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkArgument((groupId >= 0 ? 1 : 0) != 0, (Object)"groupId is negative");
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
        if (groupId == this.nullGroupId) {
            blockBuilder.appendNull();
        } else {
            BigintType.BIGINT.writeLong(blockBuilder, this.valuesByGroupId.get((long)groupId));
        }
        if (this.outputRawHash) {
            BlockBuilder hashBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset + 1);
            if (groupId == this.nullGroupId) {
                BigintType.BIGINT.writeLong(hashBlockBuilder, 0L);
            } else {
                BigintType.BIGINT.writeLong(hashBlockBuilder, BigintOperators.hashCode(this.valuesByGroupId.get((long)groupId)));
            }
        }
    }

    @Override
    public void addPage(Page page) {
        int positionCount = page.getPositionCount();
        Block block = page.getBlock(this.hashChannel);
        for (int position = 0; position < positionCount; ++position) {
            this.putIfAbsent(position, block);
        }
    }

    @Override
    public GroupByIdBlock getGroupIds(Page page) {
        int positionCount = page.getPositionCount();
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Block block = page.getBlock(this.hashChannel);
        for (int position = 0; position < positionCount; ++position) {
            int groupId = this.putIfAbsent(position, block);
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        return new GroupByIdBlock(this.nextGroupId, blockBuilder.build());
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels) {
        Block block = page.getBlock(this.hashChannel);
        if (block.isNull(position)) {
            return this.nullGroupId >= 0;
        }
        long value = BigintType.BIGINT.getLong(block, position);
        long hashPosition = BigintGroupByHash.getHashPosition(value, this.mask);
        int groupId;
        while ((groupId = this.groupIds.get(hashPosition)) != -1) {
            if (value == this.values.get(hashPosition)) {
                return true;
            }
            hashPosition = hashPosition + 1L & (long)this.mask;
        }
        return false;
    }

    @Override
    public int putIfAbsent(int position, Page page) {
        Block block = page.getBlock(this.hashChannel);
        return this.putIfAbsent(position, block);
    }

    @Override
    public long getRawHash(int groupId) {
        return BigintType.hash((long)this.valuesByGroupId.get((long)groupId));
    }

    private int putIfAbsent(int position, Block block) {
        int groupId;
        if (block.isNull(position)) {
            if (this.nullGroupId < 0) {
                this.nullGroupId = this.nextGroupId++;
            }
            return this.nullGroupId;
        }
        long value = BigintType.BIGINT.getLong(block, position);
        long hashPosition = BigintGroupByHash.getHashPosition(value, this.mask);
        while ((groupId = this.groupIds.get(hashPosition)) != -1) {
            if (value == this.values.get(hashPosition)) {
                return groupId;
            }
            hashPosition = hashPosition + 1L & (long)this.mask;
            ++this.hashCollisions;
        }
        return this.addNewGroup(hashPosition, value);
    }

    private int addNewGroup(long hashPosition, long value) {
        int groupId = this.nextGroupId++;
        this.values.set(hashPosition, value);
        this.valuesByGroupId.set((long)groupId, value);
        this.groupIds.set(hashPosition, groupId);
        if (this.nextGroupId >= this.maxFill) {
            this.rehash();
        }
        return groupId;
    }

    private void rehash() {
        this.expectedHashCollisions += HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = (int)newCapacityLong;
        int newMask = newCapacity - 1;
        LongBigArray newValues = new LongBigArray();
        newValues.ensureCapacity((long)newCapacity);
        IntBigArray newGroupIds = new IntBigArray(-1);
        newGroupIds.ensureCapacity((long)newCapacity);
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            if (groupId == this.nullGroupId) continue;
            long value = this.valuesByGroupId.get((long)groupId);
            long hashPosition = BigintGroupByHash.getHashPosition(value, newMask);
            while (newGroupIds.get(hashPosition) != -1) {
                hashPosition = hashPosition + 1L & (long)newMask;
                ++this.hashCollisions;
            }
            newValues.set(hashPosition, value);
            newGroupIds.set(hashPosition, groupId);
        }
        this.mask = newMask;
        this.hashCapacity = newCapacity;
        this.maxFill = BigintGroupByHash.calculateMaxFill(this.hashCapacity);
        this.values = newValues;
        this.groupIds = newGroupIds;
        this.valuesByGroupId.ensureCapacity((long)this.maxFill);
    }

    private static long getHashPosition(long rawHash, int mask) {
        return HashCommon.murmurHash3((long)rawHash) & (long)mask;
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashCapacity must greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashCapacity must be larger than maxFill");
        return maxFill;
    }
}

