/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.metadata.StaticCatalogStoreConfig;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class StaticCatalogStore {
    private static final Logger log = Logger.get(StaticCatalogStore.class);
    private final ConnectorManager connectorManager;
    private final File catalogConfigurationDir;
    private final Set<String> disabledCatalogs;
    private final AtomicBoolean catalogsLoading = new AtomicBoolean();
    private final AtomicBoolean catalogsLoaded = new AtomicBoolean();

    @Inject
    public StaticCatalogStore(ConnectorManager connectorManager, StaticCatalogStoreConfig config) {
        this(connectorManager, config.getCatalogConfigurationDir(), (List)MoreObjects.firstNonNull(config.getDisabledCatalogs(), (Object)ImmutableList.of()));
    }

    public StaticCatalogStore(ConnectorManager connectorManager, File catalogConfigurationDir, List<String> disabledCatalogs) {
        this.connectorManager = connectorManager;
        this.catalogConfigurationDir = catalogConfigurationDir;
        this.disabledCatalogs = ImmutableSet.copyOf(disabledCatalogs);
    }

    public boolean areCatalogsLoaded() {
        return this.catalogsLoaded.get();
    }

    public void loadCatalogs() throws Exception {
        if (!this.catalogsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : StaticCatalogStore.listFiles(this.catalogConfigurationDir)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            this.loadCatalog(file);
        }
        this.catalogsLoaded.set(true);
    }

    private void loadCatalog(File file) throws Exception {
        String catalogName = Files.getNameWithoutExtension((String)file.getName());
        if (this.disabledCatalogs.contains(catalogName)) {
            log.info("Skipping disabled catalog %s", new Object[]{catalogName});
            return;
        }
        log.info("-- Loading catalog %s --", new Object[]{file});
        HashMap<String, String> properties = new HashMap<String, String>(StaticCatalogStore.loadProperties(file));
        String connectorName = (String)properties.remove("connector.name");
        Preconditions.checkState((connectorName != null ? 1 : 0) != 0, (String)"Catalog configuration %s does not contain connector.name", (Object[])new Object[]{file.getAbsoluteFile()});
        this.connectorManager.createConnection(catalogName, connectorName, (Map<String, String>)ImmutableMap.copyOf(properties));
        log.info("-- Added catalog %s using connector %s --", new Object[]{catalogName, connectorName});
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static Map<String, String> loadProperties(File file) throws Exception {
        Objects.requireNonNull(file, "file is null");
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        return Maps.fromProperties((Properties)properties);
    }
}

