/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.annotations.ScalarFromAnnotationsParser;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.SqlWindowFunction;
import com.facebook.presto.operator.window.WindowAnnotationsParser;
import com.facebook.presto.spi.function.ValueWindowFunction;
import com.facebook.presto.spi.function.WindowFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FunctionListBuilder {
    private final List<SqlFunction> functions = new ArrayList<SqlFunction>();

    public FunctionListBuilder window(String name, Type returnType, List<? extends Type> argumentTypes, Class<? extends WindowFunction> functionClass) {
        ReflectionWindowFunctionSupplier<? extends WindowFunction> windowFunctionSupplier = new ReflectionWindowFunctionSupplier<WindowFunction>(new Signature(name, FunctionKind.WINDOW, returnType.getTypeSignature(), Lists.transform((List)ImmutableList.copyOf(argumentTypes), Type::getTypeSignature)), functionClass);
        this.functions.add(new SqlWindowFunction(windowFunctionSupplier));
        return this;
    }

    public FunctionListBuilder window(String name, Class<? extends ValueWindowFunction> clazz, String typeVariable, String ... argumentTypes) {
        Signature signature = new Signature(name, FunctionKind.WINDOW, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable(typeVariable)), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)typeVariable), (List)Arrays.asList(argumentTypes).stream().map(TypeSignature::parseTypeSignature).collect(ImmutableCollectors.toImmutableList()), false);
        this.functions.add(new SqlWindowFunction(new ReflectionWindowFunctionSupplier<ValueWindowFunction>(signature, clazz)));
        return this;
    }

    public FunctionListBuilder window(Class<? extends WindowFunction> clazz) {
        this.functions.addAll(WindowAnnotationsParser.parseFunctionDefinition(clazz));
        return this;
    }

    public FunctionListBuilder aggregate(Class<?> aggregationDefinition) {
        this.functions.addAll(SqlAggregationFunction.createByAnnotations(aggregationDefinition));
        return this;
    }

    public FunctionListBuilder scalar(Class<?> clazz) {
        this.functions.addAll(ScalarFromAnnotationsParser.parseFunctionDefinition(clazz));
        return this;
    }

    public FunctionListBuilder scalars(Class<?> clazz) {
        this.functions.addAll(ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz));
        return this;
    }

    public FunctionListBuilder functions(SqlFunction ... sqlFunctions) {
        for (SqlFunction sqlFunction : sqlFunctions) {
            this.function(sqlFunction);
        }
        return this;
    }

    public FunctionListBuilder function(SqlFunction sqlFunction) {
        Objects.requireNonNull(sqlFunction, "parametricFunction is null");
        this.functions.add(sqlFunction);
        return this;
    }

    public List<SqlFunction> getFunctions() {
        return ImmutableList.copyOf(this.functions);
    }
}

