/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TaskStatus {
    public static final long STARTING_VERSION = 1L;
    private static final long MIN_VERSION = 0L;
    private static final long MAX_VERSION = Long.MAX_VALUE;
    private final TaskId taskId;
    private final String taskInstanceId;
    private final long version;
    private final TaskState state;
    private final URI self;
    private final int queuedPartitionedDrivers;
    private final int runningPartitionedDrivers;
    private final DataSize memoryReservation;
    private final List<ExecutionFailureInfo> failures;

    @JsonCreator
    public TaskStatus(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="taskInstanceId") String taskInstanceId, @JsonProperty(value="version") long version, @JsonProperty(value="state") TaskState state, @JsonProperty(value="self") URI self, @JsonProperty(value="failures") List<ExecutionFailureInfo> failures, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="memoryReservation") DataSize memoryReservation) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        Preconditions.checkState((version >= 0L ? 1 : 0) != 0, (Object)"version must be >= MIN_VERSION");
        this.version = version;
        this.state = Objects.requireNonNull(state, "state is null");
        this.self = Objects.requireNonNull(self, "self is null");
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers must be positive");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers must be positive");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        this.memoryReservation = Objects.requireNonNull(memoryReservation, "memoryReservation is null");
        this.failures = ImmutableList.copyOf((Collection)Objects.requireNonNull(failures, "failures is null"));
    }

    @JsonProperty
    public TaskId getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public String getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public TaskState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getFailures() {
        return this.failures;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("state", (Object)this.state).toString();
    }

    public static TaskStatus initialTaskStatus(TaskId taskId, URI location) {
        return new TaskStatus(taskId, "", 0L, TaskState.PLANNED, location, (List<ExecutionFailureInfo>)ImmutableList.of(), 0, 0, new DataSize(0.0, DataSize.Unit.BYTE));
    }

    public static TaskStatus failWith(TaskStatus taskStatus, TaskState state, List<ExecutionFailureInfo> exceptions) {
        return new TaskStatus(taskStatus.getTaskId(), taskStatus.getTaskInstanceId(), Long.MAX_VALUE, state, taskStatus.getSelf(), exceptions, taskStatus.getQueuedPartitionedDrivers(), taskStatus.getRunningPartitionedDrivers(), taskStatus.getMemoryReservation());
    }
}

