/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Stream;

public enum StageState {
    PLANNED(false, false),
    SCHEDULING(false, false),
    SCHEDULING_SPLITS(false, false),
    SCHEDULED(false, false),
    RUNNING(false, false),
    FINISHED(true, false),
    CANCELED(true, false),
    ABORTED(true, true),
    FAILED(true, true);

    public static final Set<StageState> TERMINAL_STAGE_STATES;
    private final boolean doneState;
    private final boolean failureState;

    private StageState(boolean doneState, boolean failureState) {
        Preconditions.checkArgument((!failureState || doneState ? 1 : 0) != 0, (String)"%s is a non-done failure state", (Object[])new Object[]{this.name()});
        this.doneState = doneState;
        this.failureState = failureState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public boolean isFailure() {
        return this.failureState;
    }

    static {
        TERMINAL_STAGE_STATES = (Set)Stream.of(StageState.values()).filter(StageState::isDone).collect(ImmutableCollectors.toImmutableSet());
    }
}

