/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlTaskManagerStats {
    private final CounterStat scheduledSplits = new CounterStat();
    private final CounterStat startedSplits = new CounterStat();
    private final CounterStat completedSplits = new CounterStat();
    private final CounterStat completedPositions = new CounterStat();
    private final CounterStat completedBytes = new CounterStat();
    private final CounterStat splitWallTime = new CounterStat();
    private final CounterStat splitCpuTime = new CounterStat();
    private final TimeStat splitQueuedTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat timeToFirstByte = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat timeToLastByte = new TimeStat(TimeUnit.MILLISECONDS);

    @Managed
    @Nested
    public CounterStat getScheduledSplits() {
        return this.scheduledSplits;
    }

    @Managed
    @Nested
    public CounterStat getStartedSplits() {
        return this.startedSplits;
    }

    @Managed
    @Nested
    public CounterStat getCompletedSplits() {
        return this.completedSplits;
    }

    @Managed
    @Nested
    public CounterStat getCompletedPositions() {
        return this.completedPositions;
    }

    @Managed
    @Nested
    public CounterStat getCompletedBytes() {
        return this.completedBytes;
    }

    @Managed
    @Nested
    public CounterStat getSplitWallTime() {
        return this.splitWallTime;
    }

    @Managed
    @Nested
    public CounterStat getSplitCpuTime() {
        return this.splitCpuTime;
    }

    @Managed
    @Nested
    public TimeStat getTimeToFirstByte() {
        return this.timeToFirstByte;
    }

    @Managed
    @Nested
    public TimeStat getSplitQueuedTime() {
        return this.splitQueuedTime;
    }

    @Managed
    @Nested
    public TimeStat getTimeToLastByte() {
        return this.timeToLastByte;
    }

    @Managed
    public long getRunningSplits() {
        return Math.max(0L, this.startedSplits.getTotalCount() - this.completedSplits.getTotalCount());
    }

    public void addSplits(int count) {
        this.scheduledSplits.update((long)count);
    }

    public void splitStarted() {
        this.startedSplits.update(1L);
    }

    public void splitCompleted() {
        this.completedSplits.update(1L);
    }

    public void addSplitCpuTime(Duration duration) {
        this.splitCpuTime.update(duration.toMillis());
    }

    public void addSplitWallTime(Duration duration) {
        this.splitWallTime.update(duration.toMillis());
    }

    public void addCompletedPositions(long positions) {
        this.completedPositions.update(positions);
    }

    public void addCompletedDataSize(DataSize addedDataSize) {
        this.completedBytes.update(addedDataSize.toBytes());
    }

    public void addSplitQueuedTime(Duration duration) {
        this.splitQueuedTime.add(duration);
    }

    public void addTimeToFirstByte(Duration duration) {
        this.timeToFirstByte.add(duration);
    }

    public void addTimeToLastByte(Duration duration) {
        this.timeToLastByte.add(duration);
    }
}

