/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class RenameSchemaTask
implements DataDefinitionTask<RenameSchema> {
    @Override
    public String getName() {
        return "RENAME SCHEMA";
    }

    @Override
    public CompletableFuture<?> execute(RenameSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()));
        CatalogSchemaName target = new CatalogSchemaName(source.getCatalogName(), statement.getTarget());
        if (!metadata.schemaExists(session, source)) {
            throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)statement, "Schema '%s' does not exist", source);
        }
        if (metadata.schemaExists(session, target)) {
            throw new SemanticException(SemanticErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Target schema '%s' already exists", target);
        }
        accessControl.checkCanRenameSchema(session.getRequiredTransactionId(), session.getIdentity(), source, statement.getTarget());
        metadata.renameSchema(session, source, statement.getTarget());
        return CompletableFuture.completedFuture(null);
    }
}

