/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class RenameColumnTask
implements DataDefinitionTask<RenameColumn> {
    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public CompletableFuture<?> execute(RenameColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        String source = statement.getSource().toLowerCase(Locale.ENGLISH);
        String target = statement.getTarget().toLowerCase(Locale.ENGLISH);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        accessControl.checkCanRenameColumn(session.getRequiredTransactionId(), session.getIdentity(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
        if (!columnHandles.containsKey(source)) {
            throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)statement, "Column '%s' does not exist", source);
        }
        if (columnHandles.containsKey(target)) {
            throw new SemanticException(SemanticErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", target);
        }
        metadata.renameColumn(session, tableHandle.get(), columnHandles.get(source), target);
        return CompletableFuture.completedFuture(null);
    }
}

