/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FutureStateChange<T> {
    @GuardedBy(value="listeners")
    private final Set<CompletableFuture<T>> listeners = new HashSet<CompletableFuture<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> createNewListener() {
        CompletableFuture listener = new CompletableFuture();
        Set<CompletableFuture<T>> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        listener.whenComplete((t, throwable) -> {
            Set<CompletableFuture<T>> set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
        });
        return listener;
    }

    public void complete(T newState) {
        this.fireStateChange(newState, MoreExecutors.directExecutor());
    }

    public void complete(T newState, Executor executor) {
        this.fireStateChange(newState, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(T newState, Executor executor) {
        ImmutableSet futures;
        Objects.requireNonNull(executor, "executor is null");
        Set<CompletableFuture<T>> set = this.listeners;
        synchronized (set) {
            futures = ImmutableSet.copyOf(this.listeners);
            this.listeners.clear();
        }
        for (CompletableFuture future : futures) {
            executor.execute(() -> future.complete(newState));
        }
    }
}

