/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.transaction.InternalConnector;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class GlobalSystemConnector
implements InternalConnector {
    public static final String NAME = "system";
    private final String connectorId;
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;

    public GlobalSystemConnector(String connectorId, Set<SystemTable> systemTables, Set<Procedure> procedures) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new GlobalSystemTransactionHandle(this.connectorId, transactionId);
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return new ConnectorMetadata(){

            public List<String> listSchemaNames(ConnectorSession session) {
                return ImmutableList.of();
            }

            public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
                return null;
            }

            public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
                throw new UnsupportedOperationException();
            }

            public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
                throw new UnsupportedOperationException();
            }

            public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
                throw new UnsupportedOperationException();
            }

            public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
                return ImmutableList.of();
            }

            public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
                throw new UnsupportedOperationException();
            }

            public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
                throw new UnsupportedOperationException();
            }

            public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
                return ImmutableMap.of();
            }
        };
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(){};
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return (transactionHandle, session, split, columns) -> {
            throw new UnsupportedOperationException();
        };
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }
}

