/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Types;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class CatalogSystemTable
implements SystemTable {
    public static final SchemaTableName CATALOG_TABLE_NAME = new SchemaTableName("metadata", "catalogs");
    public static final ConnectorTableMetadata CATALOG_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(CATALOG_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("connector_id", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final TransactionManager transactionManager;

    @Inject
    public CatalogSystemTable(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return CATALOG_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        TransactionId transactionId = Types.checkType(transactionHandle, GlobalSystemTransactionHandle.class, "transactionHandle").getTransactionId();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)CATALOG_TABLE);
        for (Map.Entry<String, ConnectorId> entry : this.transactionManager.getCatalogNames(transactionId).entrySet()) {
            table.addRow(new Object[]{entry.getKey(), entry.getValue().toString()});
        }
        return table.build().cursor();
    }
}

