/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.units.DataSize;

public class ExceededMemoryLimitException
extends PrestoException {
    private final DataSize maxMemory;

    public static ExceededMemoryLimitException exceededGlobalLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(maxMemory, String.format("Query exceeded max memory size of %s", maxMemory));
    }

    public static ExceededMemoryLimitException exceededLocalLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(maxMemory, String.format("Query exceeded local memory limit of %s", maxMemory));
    }

    private ExceededMemoryLimitException(DataSize maxMemory, String message) {
        super((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_MEMORY_LIMIT, message);
        this.maxMemory = maxMemory;
    }

    public DataSize getMaxMemory() {
        return this.maxMemory;
    }
}

