/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Strings;
import java.util.Objects;

public class TableOfflineException
extends PrestoException {
    private final SchemaTableName tableName;

    public TableOfflineException(SchemaTableName tableName, boolean forPresto, String offlineMessage) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_OFFLINE, TableOfflineException.formatMessage(tableName, forPresto, offlineMessage));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    private static String formatMessage(SchemaTableName tableName, boolean forPresto, String offlineMessage) {
        StringBuilder resultBuilder = new StringBuilder().append("Table '").append(tableName).append("'").append(" is offline");
        if (forPresto) {
            resultBuilder.append(" for Presto");
        }
        if (!Strings.isNullOrEmpty((String)offlineMessage)) {
            resultBuilder.append(": ").append(offlineMessage);
        }
        return resultBuilder.toString();
    }
}

