/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;

public class StaticMetastoreConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<URI> metastoreUris;

    @NotNull
    public List<URI> getMetastoreUris() {
        return this.metastoreUris;
    }

    @Config(value="hive.metastore.uri")
    @ConfigDescription(value="Hive metastore URIs (comma separated)")
    public StaticMetastoreConfig setMetastoreUris(String uris) {
        if (uris == null) {
            this.metastoreUris = null;
            return this;
        }
        this.metastoreUris = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)SPLITTER.split((CharSequence)uris), URI::create));
        return this;
    }
}

