/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.hive.orc.OrcConf;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.S3ConfigurationUpdater;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.SocksSocketFactory;

public class HdfsConfigurationUpdater {
    private final HostAndPort socksProxy;
    private final Duration ipcPingInterval;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final String domainSocketPath;
    private final Configuration resourcesConfiguration;
    private final HiveCompressionCodec compressionCodec;
    private final int fileSystemMaxCacheSize;
    private final S3ConfigurationUpdater s3ConfigurationUpdater;

    @VisibleForTesting
    public HdfsConfigurationUpdater(HiveClientConfig config) {
        this(config, ignored -> {});
    }

    @Inject
    public HdfsConfigurationUpdater(HiveClientConfig config, S3ConfigurationUpdater s3ConfigurationUpdater) {
        Objects.requireNonNull(config, "config is null");
        Preconditions.checkArgument((config.getDfsTimeout().toMillis() >= 1L ? 1 : 0) != 0, (Object)"dfsTimeout must be at least 1 ms");
        this.socksProxy = config.getMetastoreSocksProxy();
        this.ipcPingInterval = config.getIpcPingInterval();
        this.dfsTimeout = config.getDfsTimeout();
        this.dfsConnectTimeout = config.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = config.getDfsConnectMaxRetries();
        this.domainSocketPath = config.getDomainSocketPath();
        this.resourcesConfiguration = HdfsConfigurationUpdater.readConfiguration(config.getResourceConfigFiles());
        this.compressionCodec = config.getHiveCompressionCodec();
        this.fileSystemMaxCacheSize = config.getFileSystemMaxCacheSize();
        this.s3ConfigurationUpdater = Objects.requireNonNull(s3ConfigurationUpdater, "s3ConfigurationUpdater is null");
    }

    private static Configuration readConfiguration(List<String> resourcePaths) {
        Configuration result = new Configuration(false);
        if (resourcePaths == null) {
            return result;
        }
        for (String resourcePath : resourcePaths) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            ConfigurationUtils.copy(resourceProperties, result);
        }
        return result;
    }

    public void updateConfiguration(Configuration config) {
        ConfigurationUtils.copy(this.resourcesConfiguration, config);
        config.setClass("topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", new String[]{this.domainSocketPath});
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset("dfs.client.read.shortcircuit", true);
        }
        config.setInt("dfs.socket.timeout", Math.toIntExact(this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Math.toIntExact(this.ipcPingInterval.toMillis()));
        config.setInt("ipc.client.connect.timeout", Math.toIntExact(this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        config.setInt("fs.cache.max-size", this.fileSystemMaxCacheSize);
        HdfsConfigurationUpdater.configureCompression(config, this.compressionCodec);
        this.s3ConfigurationUpdater.updateConfiguration(config);
    }

    public static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        config.set(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, compressionCodec.getOrcCompressionKind().name());
        config.set(OrcConf.ConfVars.HIVE_ORC_COMPRESSION.varname, compressionCodec.getOrcCompressionKind().name());
        config.set(OrcFile.OrcTableProperties.COMPRESSION.getPropName(), compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compressionCodec.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compressionCodec.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", compressionCodec.getParquetCompressionCodec().name());
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

