/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.admin;

import com.enation.app.javashop.client.system.RoleClient;
import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.model.base.CachePrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.AntPathMatcher;

public class AdminSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private RoleClient roleClient;
    private Cache cache;

    public AdminSecurityMetadataSource(RoleClient roleClient, Cache cache) {
        this.roleClient = roleClient;
        this.cache = cache;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        FilterInvocation fi = (FilterInvocation)object;
        String url = fi.getRequestUrl();
        return this.buildAttributes(url);
    }

    private Collection<ConfigAttribute> buildAttributes(String url) {
        ArrayList<String> roleList = new ArrayList<String>();
        Map roleMap = (Map)this.cache.get((Object)CachePrefix.ADMIN_URL_ROLE.getPrefix());
        if (roleMap == null) {
            roleMap = this.roleClient.getRoleMap();
        }
        if (roleMap != null) {
            for (String role : roleMap.keySet()) {
                List urlList = (List)roleMap.get(role);
                if (!this.matchUrl(urlList, url)) continue;
                roleList.add("ROLE_" + role);
            }
        }
        if (roleList.isEmpty()) {
            return SecurityConfig.createList((String[])new String[]{"ROLE_SUPER_ADMIN"});
        }
        return SecurityConfig.createList((String[])roleList.toArray(new String[roleList.size()]));
    }

    private boolean matchUrl(List<String> patternList, String url) {
        for (String expression : patternList) {
            boolean isMatch = Pattern.matches(expression, url);
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }
}

