/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.admin;

import com.enation.app.javashop.framework.context.user.AdminUserContext;
import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

public class AdminAccessDecisionManager
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        boolean bool;
        AntPathMatcher matcher = new AntPathMatcher();
        FilterInvocation filterInvocation = (FilterInvocation)object;
        String url = filterInvocation.getRequestUrl();
        Boolean result = matcher.match("/swagger-ui.html", url);
        result = result != false || matcher.match("/v2/api-docs**", url);
        result = result != false || matcher.match("/configuration/ui", url);
        result = result != false || matcher.match("/swagger-resources/**", url);
        result = result != false || matcher.match("/webjars/**", url);
        result = result != false || matcher.match("/configuration/security", url);
        if ((result = Boolean.valueOf(result != false || matcher.match("/admin/self-service/**", url))).booleanValue()) {
            return;
        }
        result = matcher.match("/admin/systems/admin-users/login**", url);
        result = result != false || matcher.match("/admin/systems/admin-users/token**", url);
        result = result != false || matcher.match("/admin/systems/admin-users/logout**", url);
        if ((result = Boolean.valueOf(result != false || matcher.match("/admin/live-video/room/store**", url))).booleanValue()) {
            return;
        }
        if (AdminUserContext.getAdmin() != null && (bool = this.adminRolesChecked(url))) {
            return;
        }
        if (CollectionUtils.isEmpty(configAttributes)) {
            throw new AccessDeniedException("not allow");
        }
        for (ConfigAttribute ca : configAttributes) {
            String needRole = ca.getAttribute();
            for (GrantedAuthority ga : authentication.getAuthorities()) {
                if ("ROLE_SUPER_ADMIN".equals(ga.getAuthority())) {
                    return;
                }
                if (!ga.getAuthority().equals(needRole)) continue;
                return;
            }
        }
    }

    private boolean adminRolesChecked(String url) {
        if ("/admin/index/page".equals(url)) {
            return true;
        }
        boolean isMatch = Pattern.matches("/admin/systems/roles/[1-9].*", url);
        isMatch = isMatch || Pattern.matches("/regions/[1-9].*", url);
        isMatch = isMatch || Pattern.matches("/uploaders.*", url);
        isMatch = isMatch || Pattern.matches("/admin/stores.*", url);
        isMatch = isMatch || Pattern.matches("/admin/index/page.*", url);
        return isMatch;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

