/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.seller;

import com.enation.app.javashop.framework.context.user.UserContext;
import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

public class SellerAccessDecisionManager
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        boolean bool;
        AntPathMatcher matcher = new AntPathMatcher();
        FilterInvocation filterInvocation = (FilterInvocation)object;
        String url = filterInvocation.getRequestUrl();
        Boolean result = matcher.match("/swagger-ui.html", url);
        result = result != false || matcher.match("/v2/api-docs**", url);
        result = result != false || matcher.match("/configuration/ui", url);
        result = result != false || matcher.match("/swagger-resources/**", url);
        result = result != false || matcher.match("/webjars/**", url);
        result = result != false || matcher.match("/configuration/security", url);
        result = result != false || matcher.match("/seller/login/**", url);
        result = result != false || matcher.match("/seller/register**", url);
        result = result != false || matcher.match("/seller/register/**", url);
        result = result != false || matcher.match("/seller/check/**", url);
        result = result != false || matcher.match("/seller/check/**", url);
        result = result != false || matcher.match("/seller/shops/**", url);
        result = result != false || matcher.match("/seller/live-video/media/**", url);
        if ((result = Boolean.valueOf(result != false || "/seller/shops/status".equals(url))).booleanValue()) {
            return;
        }
        if (UserContext.getSeller() != null && (bool = this.rolesChecked(url))) {
            return;
        }
        if (CollectionUtils.isEmpty(configAttributes)) {
            throw new AccessDeniedException("not allow");
        }
        for (ConfigAttribute ca : configAttributes) {
            String needRole = ca.getAttribute();
            for (GrantedAuthority ga : authentication.getAuthorities()) {
                if ("ROLE_SELLER_SUPER_SELLER".equals(ga.getAuthority())) {
                    return;
                }
                if (!ga.getAuthority().equals(needRole)) continue;
                return;
            }
        }
        throw new AccessDeniedException("not allow");
    }

    private boolean rolesChecked(String url) {
        if ("/seller/shops/".equals(url) | "/seller/shops".equals(url)) {
            return true;
        }
        boolean isMatch = Pattern.matches("/seller/shops/roles/[1-9]+[0-9]*/checked$", url);
        isMatch = isMatch || Pattern.matches("/seller/statistics.*", url);
        isMatch = isMatch || Pattern.matches("/seller/members/logout.*", url);
        return isMatch;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

