/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.handler;

import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.util.Sha256;
import com.enation.app.javashop.model.base.FeignSetting;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeignInterceptor
implements RequestInterceptor {
    @Autowired
    private FeignSetting feignSetting;

    public void apply(RequestTemplate requestTemplate) {
        String appId = this.feignSetting.getAppId();
        String secretId = this.feignSetting.getSecretId();
        requestTemplate.header("appId", new String[]{this.feignSetting.getAppId()});
        String timestamp = System.currentTimeMillis() + "";
        requestTemplate.header("timestamp", new String[]{timestamp});
        String signature = Sha256.getSHA1((String)appId, (String)timestamp, (String)secretId);
        requestTemplate.header("signature", new String[]{signature});
        Map<String, String> parameters = this.getParameters();
        for (String parameter : parameters.keySet()) {
            String regex = "(\\{(.*)})";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(parameters.get(parameter));
            if (matcher.find()) continue;
            requestTemplate.query(parameter, new String[]{parameters.get(parameter)});
        }
    }

    private Map<String, String> getParameters() {
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        if (request == null) {
            return new HashMap<String, String>();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = request.getParameter(key);
            map.put(key, value);
        }
        return map;
    }
}

