/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.database;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.database.impl.DaoSupportImpl;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(value={"javashop.product"}, havingValue="microservice")
public class DataSourceMicroConfig {
    @Bean
    @Primary
    public DaoSupport daoSupport(JdbcTemplate jdbcTemplate) {
        DaoSupportImpl daosupport = new DaoSupportImpl(jdbcTemplate);
        return daosupport;
    }

    @Bean
    public DaoSupport roleDaoSupport(@Qualifier(value="roleJdbcTemplate") JdbcTemplate roleJdbcTemplate) {
        DaoSupportImpl daosupport = new DaoSupportImpl(roleJdbcTemplate);
        return daosupport;
    }

    @Bean(name={"goodsDaoSupport"})
    public DaoSupport goodsDaoSupport(@Qualifier(value="daoSupport") DaoSupport daosupport) {
        return daosupport;
    }

    @Bean(name={"tradeDaoSupport"})
    public DaoSupport tradeDaoSupport(@Qualifier(value="daoSupport") DaoSupport daosupport) {
        return daosupport;
    }

    @Bean(name={"memberDaoSupport"})
    public DaoSupport memberDaoSupport(@Qualifier(value="daoSupport") DaoSupport daosupport) {
        return daosupport;
    }

    @Bean(name={"systemDaoSupport"})
    public DaoSupport systemDaoSupport(@Qualifier(value="daoSupport") DaoSupport daosupport) {
        return daosupport;
    }

    @Bean(name={"sssDaoSupport"})
    public DaoSupport sssDaoSupport(@Qualifier(value="daoSupport") DaoSupport daosupport) {
        return daosupport;
    }

    @Bean(name={"distributionDaoSupport"})
    public DaoSupport distributionDaoSupport(@Qualifier(value="daoSupport") DaoSupport daosupport) {
        return daosupport;
    }

    @Bean
    public JdbcTemplate jdbcTemplate(@Qualifier(value="dataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name={"roleJdbcTemplate"})
    public JdbcTemplate roleJdbcTemplate(@Qualifier(value="roleDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name={"sssJdbcTemplate"})
    public JdbcTemplate sssJdbcTemplate(@Qualifier(value="dataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource dataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean(value={"roleDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.role")
    public DataSource roleDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean
    public PlatformTransactionManager memberTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    @Primary
    public PlatformTransactionManager goodsTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public PlatformTransactionManager tradeTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public PlatformTransactionManager systemTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public PlatformTransactionManager sssTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public PlatformTransactionManager distributionTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public PlatformTransactionManager transactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public PlatformTransactionManager roleTransactionManager(@Qualifier(value="roleDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

